/*

				Text Chat Dialogue

	Text chat takes place in a modeless dialogue which
	the user can arrange on the screen as desired.
	 
*/

#include "netfone.h"


//  CHATINPUT  --  Edit control which notifies parent of return key. 

static WNDPROC lpfnOldEdit = NULL;

#define WM_EDITRETURN	(WM_USER + 1002) 

LONG WINAPI chatInput(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{

	if (message == WM_GETDLGCODE) {
		return DLGC_WANTALLKEYS;		// We want to see Tab, Return, etc.
	}

	if (message == WM_KEYDOWN) {
		if (wParam == VK_RETURN) {
			SendMessage(GetParent(hWnd), WM_COMMAND,
				MAKELONG(GetWindowLong(hWnd, GWL_ID), WM_EDITRETURN),
				(LPARAM) hWnd);
			return 0L;
		}
		if (wParam == VK_TAB) {
			SetFocus(GetDlgItem(hDlgChat, IDC_CHAT_SEND));
			return 0L;
		}
	}
	
	//	Must eat return and tab WM_CHAR messages to avoid inane "bing"
	if ((message == WM_CHAR) &&
		((wParam == '\t')) || (wParam == '\r')) {
		return 0L;
	}
	
	return CallWindowProc(lpfnOldEdit, hWnd, message, wParam, lParam);
}

//	CHATDLGPROC  --  Chat dialogue procedure

#define WM_CHAT_TEXT	(WM_USER + 1003)

BOOL CALLBACK chatDlgProc(HWND hwnd, UINT nMessage, WPARAM wParam, LPARAM lParam)
{
	int l, n;
	char s[256];
	LPSTR content;

    switch (nMessage) {
    	case WM_INITDIALOG:
			hDlgChat = hwnd;

			//	Subclass text input control so return sends line
			
			lpfnOldEdit = (WNDPROC) GetWindowLong(GetDlgItem(hwnd, IDC_CHAT_INPUT),
										GWL_WNDPROC);
			SetWindowLong(GetDlgItem(hwnd, IDC_CHAT_INPUT), GWL_WNDPROC,
										(LONG) chatInput);

			SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_SETREADONLY, TRUE, 0);
			SetFocus(GetDlgItem(hwnd, IDC_CHAT_SEND));
	    	return TRUE;
	    	
	    case WM_CLOSE:
	    	DestroyWindow(hwnd);
	    	return TRUE;

		case WM_CHAT_TEXT:
			l = SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, WM_GETTEXTLENGTH, 0, 0);
			SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_SETSEL, l, l);
			SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_REPLACESEL, 0, lParam);
			SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_SCROLLCARET, 0, 0);
			GlobalFree((LPSTR) lParam);
			return TRUE;

        case WM_COMMAND:
		    switch ((short) WM_COMMAND_ID(wParam)) {

		    	case IDOK:
		        	PostMessage(hwnd, WM_CLOSE, 0, 0L);
		        	break;
		        	
                case ID_HELP:
                	displayHelpTopic(IDS_HELP_CHAT);
                	break;

				case IDC_CHAT_CLEAR:
					SetDlgItemText(hwnd, IDC_CHAT_TRANSCRIPT,"");
					break;

				case IDC_CHAT_SEND:
					if (protocolSent != PROTOCOL_SPEAKFREE) {
						MessageBox(hwnd, rstring(IDS_CHAT_PROTOCOL), pszAppName, MB_OK | MB_ICONEXCLAMATION);
					} else {
						strcpy(s, rstring(IDS_CHAT_MYTEXT));
						l = strlen(s);
						if ((n = GetDlgItemText(hwnd, IDC_CHAT_INPUT, s + l, sizeof(s) - (l + 4))) > 0) {
							while ((n > 0) && isspace(s[(l + n) - 1])) {
								n--;
							}
							strcpy(s + l + n, "\r\n");
							SetDlgItemText(hwnd, IDC_CHAT_INPUT, "");
							if (n > 0) {
								int tl = SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, WM_GETTEXTLENGTH, 0, 0);

								SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_SETSEL, tl, tl);
								SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_REPLACESEL, 0, (LPARAM) s);
								SendDlgItemMessage(hwnd, IDC_CHAT_TRANSCRIPT, EM_SCROLLCARET, 0, 0);
								content = GlobalAlloc(GMEM_FIXED, n + 1);
								memcpy(content, s + l, n);
								content[n] = 0;
								PostMessage(hwndMDIFrame, WM_CHAT_TEXT_SEND, 0, (LPARAM) content);
							}
						}
					}
					SetFocus(GetDlgItem(hwnd, IDC_CHAT_INPUT));
					break;

				case IDC_CHAT_INPUT:
                	if (WM_COMMAND_NOTIFY == WM_EDITRETURN) {
	                	PostMessage(hwnd, WM_COMMAND, IDC_CHAT_SEND, 0L);
					}
					break;
		    }
        	return TRUE;
	    	
	    case WM_DESTROY:
	    	hDlgChat = NULL;
	    	return 0;
    }
    return FALSE;
}

//	CHATDIALOGUE  --  Chat dialogue

VOID chatDialogue(HWND hwndParent)
{
	if (hDlgChat == NULL) {
		hDlgChat = CreateDialog(hInst, MAKEINTRESOURCE(IDD_CHAT),
    					hwndParent, chatDlgProc);
	}
}

//	CHATLOG  --  Post chat data to scrolling area

void chatLog(HWND hwnd, char *ident, char *text)
{
	
	//	If chat window isn't already open, launch it

	if (hDlgChat == NULL) {
		chatDialogue(hwnd);
	}

	/*	Now, if it's set up for business, post the text message
		to it.  */

	if (hDlgChat != NULL) {
		char *sep = rstring(IDS_CHAT_SEPARATOR);
		char *mtext = GlobalAlloc(GMEM_FIXED, strlen(ident) + strlen(sep) + strlen(text) + 4);

		if (mtext != NULL) {
			strcpy(mtext, ident);
			strcat(mtext, sep);
			strcat(mtext, text);
			strcat(mtext, "\r\n");
			PostMessage(hDlgChat, WM_CHAT_TEXT, 0, (LPARAM) mtext);
		}
	}
}
