/*

				Speak Freely for Windows

*/

#include "netfone.h"

static DWORD lastYieldTime = 0;

void MessageLoop(MSG *pmsg)
{
   	if (!((hDlgPropeller != NULL && IsDialogMessage(hDlgPropeller, pmsg)) ||
   		(hDlgAnswer != NULL && IsDialogMessage(hDlgAnswer, pmsg)) ||
		(hDlgSpectral != NULL && IsDialogMessage(hDlgSpectral, pmsg)) ||
		(hDlgChat != NULL && IsDialogMessage(hDlgChat, pmsg)) ||
		(hDlgConsole != NULL && IsDialogMessage(hDlgConsole, pmsg)) ||
   		IsVoxMonitorMessage(pmsg)
   		)) {
        if (!TranslateMDISysAccel(hwndMDIClient, pmsg) &&
            !TranslateAccelerator(hwndMDIFrame, hAccel, pmsg)) {
            TranslateMessage(pmsg);
            DispatchMessage(pmsg);
        }
   }
}

void DefaultMessageLoop()
{
	MSG msg;
	
	if ((GetTickCount() - lastYieldTime) > 350) {
//OutputDebugString("DefaultMessageLoop\r\n");
		propeller(IDC_PH_MSGCHECK, ++messageChecks);
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			MessageLoop(&msg);
	  	}
    }
}

//	WINMAIN  --  Main application entry point

INT PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrev,
				   LPSTR pszCmdLine, INT nCmdShow)
{
    MSG msg;
    LPSTR cp;
    
    /* Check command line for another connection */

	hPrev = (HINSTANCE) FindWindow(SPEAK_FREE_FRAME_CLASS, NULL);
    if (hPrev) {
		HWND hwnd = FindWindow(SPEAK_FREE_FRAME_CLASS, NULL);
		
	    SendMessage(hwnd, WM_NEW_COMMANDLINE, 0, (LPARAM) pszCmdLine);
	    if (IsIconic(hwnd)) {
	    	PostMessage(hwnd, WM_SYSCOMMAND, SC_RESTORE, 0L);
	    } else {
	    	SetFocus(hwnd);
	    }
		return 0;
	}
    
    //	Disable floating point error interrupts
    
    _control87(_EM_ZERODIVIDE | _EM_OVERFLOW | _EM_INVALID | _EM_DENORMAL |
								_EM_UNDERFLOW | _EM_INEXACT,
			   _MCW_EM);
    
    //	Check for and process "start iconic" command line switch
    
    if ((cp = strstr(pszCmdLine, "-S")) != NULL ||
    	(cp = strstr(pszCmdLine, "/S")) != NULL ||
    	(cp = strstr(pszCmdLine, "-s")) != NULL ||
    	(cp = strstr(pszCmdLine, "/s")) != NULL) {
    	if ((cp == pszCmdLine || isspace(cp[-1])) &&
    		(cp[2] == 0 || isspace(cp[2]))) {
    		nCmdShow = SW_SHOWMINIMIZED;
    		memcpy(cp, "  ", 2);
    	}
    } 
    
	//	Initialise application

    if (!InitApplication(hInstance)) {
        return FALSE;
    }
    
    //	Initialise instance

    if (!InitInstance(hInstance, pszCmdLine, nCmdShow)) {
        return FALSE;
    }

	/*	MDI message dispatching loop.  The business with
		PeekMessage conspires with the anti-lockup code so
		that we only set lastYieldtime when we start
		processing a set of messages from the queue. */

    while (GetMessage(&msg, NULL, 0, 0)) {
    	MessageLoop(&msg);
	  	/*	Note that there may be a tiny timing window here
	  		that I can't think of any way to slam.  If a message
	  		gets queued by interrupt code between here and the
	  		call on GetMessage, lastYieldTime will be reset
	  		without actually yielding to another application. */
	  	if (!waNetNoMsgLoopIns &&
	  			PeekMessage(&msg, NULL, 0, 0, PM_NOYIELD | PM_NOREMOVE) == 0) {
			lastYieldTime = GetTickCount();
		}
    }
    return msg.wParam;
}
