/*
 * intro.c  
 *
 * Copyright 1998,9 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/resource.h>

#include "ppddmount.h"

int ppdd_intro (const char *progname)
{
	struct rlimit	rlim;

	printf("\n%s, version %01d.%01d (c) 1998,9 Allan Latham <alatham@flexsys-group.com>\n\n", progname, PP_VERSION/10, PP_VERSION%10);
	printf("This is licenced software but no charge is made for its use.\n");
	printf("NO WARRANTY whatsoever is offered with this product.\n");
	printf("NO LIABILITY whatsoever is accepted for its use.\n");
	printf("You are using this entirely at your OWN RISK.\n");
	printf("See the GNU Public Licence for full details.\n\n");

	rlim.rlim_cur = 0;
	rlim.rlim_max = 0;
	setrlimit(RLIMIT_CORE, &rlim);

	if (getuid()) {
	    PPDDERROR(101)
	    return 1;
	}
	return 0;
}
