#include <linux/ppdd.h>
#include <time.h>
#include "md5.h"

struct crypt_control_block {
	unsigned char 	  iv[8];
	unsigned char 	  mkey[PPDDMKSIZE];
	unsigned char 	  x1[1];
	unsigned char     keys[sizeof(struct ppdd_ukeys)];
	unsigned char 	  x2[12];
	unsigned char	  time_created[sizeof(time_t)];
	unsigned char 	  x3[1024
				 - 8 
				 - PPDDMKSIZE
				 - 1 
				 - sizeof(struct ppdd_ukeys)
				 - 12
				 - sizeof(time_t)
				 - sizeof(unsigned short)
				 - 4
				 - 4
				 - 1 
				 - 3 
				 - 16
				 - 16
				 - 4];
	unsigned char	file_version[sizeof(unsigned short)];
	unsigned char 	x4[4];
	unsigned char 	crc[4];
/* */
	unsigned char 	flags;
	unsigned char 	x5[3];
	unsigned char   pmd5[16];
	unsigned char   cmd5[16];
	unsigned char 	x6[4];
/* */
	};

/* length encrypted with md5 key */

#define CB5LENGTH (1 + 3 + 16 + 16 + 4) 

/* seek position for md5 block */

#define CB5SEEK (1024 - CB5LENGTH) 

/* length encrypted with master key */

#define CBMLENGTH (CB5SEEK - 8) 

/* length in crc */

#define CBXLENGTH (CB5SEEK - 4) 


struct crypt_type_struct {
	int id;
	char *name;
} ;

extern int ppdd_intro (const char*);
extern int find_ppdd_entry (const char*, char*, char*, char*, char*, int*);
extern int set_ppdd (const char*, const char*, const char*, const char*, 
			const char*, int, int);
extern int make_crc (struct crypt_control_block*, int);
extern unsigned long crc32(const unsigned char*, unsigned int);

extern int checkpass(int, 
	const char*, 
	const char*, 
	const char*, 
	struct ppdd_info*,
	struct crypt_control_block*,
	unsigned char*);

extern void getoldpass(int *len1, unsigned char *passphrase1,
		  	int *len2, unsigned char *passphrase2);

extern void make_key(unsigned char *key, unsigned char *iv,
					int *len1, unsigned char *passphrase1,
					int *len2, unsigned char *passphrase2);
extern int newpass(unsigned char*,
	struct crypt_control_block*, int);

extern int set_new_keys(int, int, struct ppdd_info*, 
	struct crypt_control_block*);

extern void Blowfish_Encrypt_ecb(Blowfish_Key key, unsigned char* inbuf,
                                          unsigned char* outbuf, int length);

extern void Blowfish_Decrypt_ecb(Blowfish_Key key, unsigned char* inbuf,
                                          unsigned char* outbuf, int length);

extern int read_control_block(int fd, void* buffer);

extern int write_control_block(int fd, void* buffer);

extern int write_md5_block(int fd, void* buffer);

extern int random_fill_fast (void *block, int size);

extern int random_fill_slow (void *block, int size);

extern int checkcsum(int plain, int generate, int fd, 
		struct crypt_control_block *cblock);

extern int check_access(char const *file, int fd, int fail);
 
extern void ppdderror(int, const char*, const char*);

#define PPDDERROR(a) ppdderror(a, progname, NULL);
#define PPDDEMESS(a,b) ppdderror(a, progname, b);

#define PPDD_CRC_CHECK 0
#define PPDD_CRC_MAKE 1

#ifdef _SYS_MOUNT_H
#ifndef BLKFLSBUF
#define BLKFLSBUF _IO(0x12, 97)
#endif
#endif
