/*
 * ppddreopen.c - moves the ppdd device from the inial ram disc
 *                to the real root disc.
 *
 * Copyright 1999 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */
#include <sys/mount.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <getopt.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "ppddmount.h"

static char *progname;

static int ppddreopen(const char *device, const char *file)
{
	int  ffd, fd;


	if ((ffd = open (file, O_RDWR)) < 0) {
		PPDDERROR(124)
		return 1;
	}

	check_access (file, ffd, 0);

	if ((fd = open (device, O_RDWR)) < 0) {
		PPDDERROR(125)
		return 1;
	}

	check_access (device, fd, 0);

	if (ioctl(fd, PPDD_SWAP_FILE_INODE, ffd) < 0) {
		PPDDERROR(127)
		return 1;
	}

	close (ffd);
	close (fd);
	sync();

	umount("/initrd");
	umount("/dev/ram0");

	if ((fd = open ("/dev/ram0", O_RDWR)) < 0) {
		PPDDERROR(126)
		return 1;
	}

  	ioctl(fd, BLKFLSBUF);
  	close(fd);

	return 0;
}

static int usage(void)
{
	fprintf(stderr, "usage:\n\
  %s ppdd_device new_file \n", progname);
	exit(1);
}

int main(int argc, char **argv)
{
	progname = "ppddreopen";

	if(ppdd_intro("ppddreopen")) usage();

	if (argc != 3) usage();

	return(ppddreopen(argv[1], argv[2]));
}

