/*
 * checkcsum.c - setup and control ppdd devices
 *
 * Copyright 1998,9, 2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

#include "ppddmount.h"

static int csum_all(int plain, int fd, struct ppdd_keys *keys, 
		unsigned char *pmd5, unsigned char *cmd5, const char *fname)
{
	char		*progname = "csum_all";
	unsigned char 	iblock[32768];
	int 		rlength, count, reply, iseek;
	unsigned long	size, block, dlength, mlength, tblocks;
	time_t		now, then;
	struct MD5Context pmd5C;
	struct MD5Context cmd5C;

	tblocks = getfilesize(fd);
	size = tblocks >> 11;
	printf("Calculating checksums on %s (%ldMb)\n", fname, size);

	then = time(NULL);

	MD5Init(&pmd5C);
	MD5Init(&cmd5C);

	iseek = 1024;

	lseek (fd,iseek,SEEK_SET);

	count = 1024;
	dlength = 1024;
	block = 2;
	mlength = 0;

	while (1)
	{
                if ((tblocks - block) < 65) {
                    rlength = read (fd, iblock, 512);
                } else {
                    rlength = read (fd, iblock, sizeof(iblock));
                }
		if (rlength == 0) {
		    MD5Final(pmd5, &pmd5C);
		    MD5Final(cmd5, &cmd5C);
		    return 1;
		}
		if (rlength < 0) {
			PPDDERROR(140)
			return 0;
		}
		MD5Update(&cmd5C, iblock, rlength);
		if (plain) {
	            reply = transfer_bf(keys, PPDDDECRYPT, iblock,
					iblock, rlength >> 9, block);
		    if (reply) {
			PPDDERROR(141)
			return 0;
		    }
		    MD5Update(&pmd5C, iblock, rlength);
		}
		dlength += rlength;
		block += rlength >> 9;
		count--;
		if (count == 0) {
			count = 1024;
			now = time(NULL);
			if (now > (then + 59)) {
				then = now;
	                        mlength += dlength >> 20;
        	                dlength &= 0x0fffff;
				printf("%s: %ld of %ld Mb so far\n",
					fname, mlength, size);
			}
		}
	}
	return 1;
}


int checkcsum(int plain, int generate, int fd, int tab,
			struct crypt_control_block *cblock, const char* fname) 
{
	struct ppdd_keys 		keys;
	unsigned char			cmd5[16];
	unsigned char			pmd5[16];
	int                        	i, ok, reply;
	Blowfish_Key               	bkey;

	ok = 1;
	reply = 0;

	if (!generate){
	    if (!(cblock->flags & 2)) {
	        fprintf(stderr, "No ciphertext checksum in control block.\n");
	        ok = 0;
	    }
	    if (plain && (!(cblock->flags & 1))) {
	        fprintf(stderr, "No plaintext checksum in control block.\n");
	        ok = 0;
	    }
	    if (ok) {
		if (!tab) {
	            fprintf(stderr, "Checksum this device? (Y/N): ");
	            do {	
		        reply = getc(stdin);
	            } while ((reply != 'Y') && (reply != 'y')
		        && (reply != 'N') && (reply != 'n'));
	            if ((reply == 'N') || (reply == 'n')) {
		        reply = 'Y';
	                ok = 0;
	            }
	        }
	    } else {
		if (!tab) {
	            fprintf(stderr, "Ignore missing checksum? (Y/N): ");
	            do {	
		        reply = getc(stdin);
	            } while ((reply != 'Y') && (reply != 'y')
		        && (reply != 'N') && (reply != 'n'));
	        }	
	    }	
	}
	if (ok) {
	    setup_bf((struct ppdd_ukeys*)cblock->keys, &keys);
	    ok = csum_all (plain, fd, &keys, pmd5, cmd5, fname);
	}
	if (ok) {
	    if (generate) {
	        if (plain) { 
		    memcpy(cblock->pmd5,pmd5,16);
		} else {
		    random_fill_fast(&cblock->flags,20);
		}
		memcpy(cblock->cmd5,cmd5,16);
		for(i=0;i<16;i++) cblock->cmd5[i] ^= cblock->pmd5[i];
	        cblock->flags &= 0xf0;
	        cblock->flags |= 0x02;
	        cblock->flags |= 0x08;
	        cblock->flags |= plain;
	        cblock->flags |= plain << 2;
	        Blowfish_ExpandUserKey(cblock->keys, PPDDKEYSIZE, bkey);
	        Blowfish_Encrypt_ecb(bkey, &cblock->flags,
						&cblock->flags, CB5LENGTH);
	        write_md5_block(fd, cblock);
                sync();
	    } else {
	        for(i=0;i<16;i++) cblock->cmd5[i] ^= cblock->pmd5[i];
	        if (memcmp(cblock->cmd5,cmd5,16)) {
	       	    fprintf(stderr, "Error: ciphertext checksum failed.\n");
	            ok = 0;
	        } else {
	       	    fprintf(stderr, "Ciphertext checksum OK\n");
		}
	        if (plain) { 
                    if (memcmp(cblock->pmd5,pmd5,16)) {
	       	        fprintf(stderr, "Error: plaintext checksum failed.\n");
	                ok = 0;
	            } else {
	       	        fprintf(stderr, "Plaintext checksum OK\n");
		    }
		}
		if (!ok) {
                    if (!tab) {
  	                fprintf(stderr, "Ignore checksum error? (Y/N): ");
	    	        do {	
			    reply = getc(stdin);
	    	        } while ((reply != 'Y') && (reply != 'y')
			    && (reply != 'N') && (reply != 'n'));
		    }
		}
	    }
	}
	if (!ok && (reply == 'y' || reply == 'Y')) ok = 1;
	memset(&keys, 0, sizeof(keys));
	memset(&bkey, 0, sizeof(bkey));
	return (ok);
}


