/*
 *  checkpass.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>

#include "ppddmount.h"

int checkpass(int ffd, 
		const char* ppfile, 
		const char* pass1, 
		const char* pass2, 
		struct crypt_control_block* cblock,
		unsigned char* raw,
		unsigned char* mkey)
{
	char		*progname = "checkpass";
	int		ok, len1, len2;
	unsigned char	passphrase1[136];
	unsigned char	passphrase2[136];
	unsigned char	iv[8];
	Blowfish_Key 	bkey;
	unsigned char	temp[PPDDMKSIZE];
	unsigned char	key[PPDDKEYSIZE];

	if (read_control_block(ffd, cblock)) {
		PPDDERROR(219)
		return(0);
	}

	if (raw) memcpy (raw, cblock, 1024);
	memcpy (iv, cblock, 8);

	if (ppfile) {
		readoldpass(ppfile, &len1, passphrase1, &len2, passphrase2);
	} else {
		if (pass1) {
			memcpy(passphrase1+8,pass1,120);
			memcpy(passphrase2+8,pass2,120);
			len1 = strlen(pass1);
			len2 = strlen(pass2);
		} else {
			getoldpass(&len1, passphrase1, &len2, passphrase2);
		}
	}

	make_key(key, iv, &len1, passphrase1, &len2, passphrase2);
	Blowfish_ExpandUserKey(key, PPDDKEYSIZE, bkey);
	Blowfish_Decrypt_ecb(bkey, cblock->mkey, cblock->mkey, CBMLENGTH);

	ok = 1;
	if (make_crc(cblock,PPDD_CRC_CHECK)) {
	    memcpy(temp, cblock->mkey, PPDDMKSIZE);
	    Blowfish_ExpandUserKey(&cblock->mkey[4], PPDDKEYSIZE, bkey);
	    if (read_control_block(ffd, cblock)) {
		PPDDERROR(217)
		ok = 0;
	    } else {
		Blowfish_Decrypt_ecb(bkey, cblock->mkey, cblock->mkey, 
								CBMLENGTH);
		if (make_crc(cblock,PPDD_CRC_CHECK)) {
			fprintf(stderr,
		"Wrong pass phrase or uninitialised crypto file system.\n");
			ok = 0;
		} else {
		    if (mkey) memcpy(mkey, &temp[4], PPDDKEYSIZE);
		}
	    }
	} else {
	    if (mkey) memcpy(mkey, key, PPDDKEYSIZE);
	}
	memset(temp, 0, PPDDMKSIZE);
	memset(key, 0, PPDDKEYSIZE);
	memset(bkey, 0, sizeof(bkey));
	memset(passphrase1, 0, sizeof(passphrase1));
	memset(passphrase2, 0, sizeof(passphrase2));
        len1 = len2 = 0;
	return (ok);
}
