/*
 * ppdd CIPHER module
 *
 * based on dummy cipher module by hvr@gnu.org
 *
 * ppdd uses blowfish as the underlying encryption engine
 * it always expects to work on 512 bytes of data
 * it use 17 blowfish keys and 61 unsigned long items for whitening
 * the IV is considered to be an unsigned number
 * IV mod 17 is used to select the key 
 * IV mod 59 is used to select one of the three whitening numbers
 * IV mod 61 is used to select one of the three whitening numbers
 * IV itself is the remaining whitening number
 */

#include <asm/byteorder.h>
#include <linux/crypto.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/string.h>

#include <linux/ppdd.h>

#include "transfer_bf.c"
#include "setup_bf.c"
#include "Blowfish_Encrypt_cbc.c"
#include "Blowfish_Decrypt_cbc.c"
#include "ppdd_scramble.c"
#include "ppdd_unscramble.c"

static int
ppdd_encrypt (struct cipher_context *cx, const u8 *in8, u8 *out8,
	       int size, int atomic, const u32 iv[])
{
	struct ppdd_keys *pKeys;
	int reply;
	int blocks;

        blocks = size >> 9;

/* FIX ME remove this debug code
	printk (KERN_DEBUG "%s: size=%d blocks=%d iv=%d\n",
		__PRETTY_FUNCTION__, size, blocks, iv[0]);
	    printk (KERN_DEBUG "%s: %02x %02x %02x %02x\n",
		__PRETTY_FUNCTION__,
                ((char*)cx->keyinfo)[0],
                ((char*)cx->keyinfo)[1],
                ((char*)cx->keyinfo)[2],
                ((char*)cx->keyinfo)[3]);
*/
	pKeys = (struct ppdd_keys*)cx->keyinfo;
	reply = transfer_bf(pKeys, PPDDENCRYPT, in8, out8, blocks, iv[0]);

	return reply;
}

static int
ppdd_decrypt (struct cipher_context *cx, const u8 *in8, u8 *out8,
	       int size, int atomic, const u32 iv[])
{
	struct ppdd_keys *pKeys;
	int reply;
	int blocks;

        blocks = size >> 9;

/* FIX ME this next line is needed!!!! (or the same below)
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);
*/

	printk (KERN_DEBUG "%s: size=%d blocks=%d iv=%d\n",
		__PRETTY_FUNCTION__, size, blocks, iv[0]);

/* FIX ME remove this debug code
	printk (KERN_DEBUG "%s: size=%d blocks=%d iv=%d\n",
		__PRETTY_FUNCTION__, size, blocks, iv[0]);
	    printk (KERN_DEBUG "%s: %02x %02x %02x %02x\n",
		__PRETTY_FUNCTION__,
                ((char*)cx->keyinfo)[0],
                ((char*)cx->keyinfo)[1],
                ((char*)cx->keyinfo)[2],
                ((char*)cx->keyinfo)[3]);
*/
	pKeys = (struct ppdd_keys*)cx->keyinfo;
	reply = transfer_bf(pKeys, PPDDDECRYPT, in8, out8, blocks, iv[0]);

/* FIX ME this next line is needed!!!! (or the same above)
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);
*/

	return reply;
}

static int
ppdd_set_key (struct cipher_context *cx, const unsigned char *key, int key_len,
	       int atomic)
{
	struct ppdd_keys *pKeys;
	struct ppdd_ukeys *pUKeys;

	printk (KERN_DEBUG "%s: key_len=%d atomic=%d\n",
		__PRETTY_FUNCTION__, key_len, atomic);

	if (key_len == 820) {
	    pUKeys = (struct ppdd_ukeys*)key;
	    pKeys = (struct ppdd_keys*)cx->keyinfo;
            setup_bf(pUKeys, pKeys);
/*
	    printk (KERN_DEBUG "%s: %02x %02x %02x %02x\n",
		__PRETTY_FUNCTION__,
                ((char*)cx->keyinfo)[0],
                ((char*)cx->keyinfo)[1],
                ((char*)cx->keyinfo)[2],
                ((char*)cx->keyinfo)[3]);
*/
        }
	return 0;
}

static void
ppdd_lock (void)
{
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);

	MOD_INC_USE_COUNT;
}

static void
ppdd_unlock (void)
{
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);

	MOD_DEC_USE_COUNT;
}

//#define PPDD_KEY_SCHEDULE_SIZE (((17*(18+1024))+61)*sizeof(u32))

static struct cipher_implementation ppdd_ci = {
	{{NULL, NULL}, CIPHER_MODE_CBC, "ppdd-cbc"},
      blocksize:8,
      ivsize:8,
      key_schedule_size: sizeof(struct ppdd_keys),
      key_size_mask:0,
	INIT_CIPHER_BLKOPS (ppdd),
	INIT_CIPHER_OPS (ppdd)
};

static int __init
init_ppdd (void)
{
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);

	if (register_cipher (&ppdd_ci))
		printk (KERN_WARNING
			"Couldn't register ppdd encryption\n");
	return 0;
}

static void __exit
cleanup_ppdd (void)
{
	printk (KERN_DEBUG "%s\n", __PRETTY_FUNCTION__);

	if (unregister_cipher (&ppdd_ci))
		printk (KERN_WARNING
			"Couldn't unregister ppdd encryption\n");
}

module_init (init_ppdd);
module_exit (cleanup_ppdd);

MODULE_LICENSE("GPL");

EXPORT_NO_SYMBOLS;

/* eof */
