/*
 *  Blowfish_Decrypt_cbc.c
 * 
 *  Copyright 1997,8,9 2002 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/bf.h>

void Blowfish_Decrypt_cbc (Blowfish_Key key, const unsigned char* iv,
                const unsigned char* inbuf, unsigned char* outbuf, int length)
{
    int i;
    unsigned long niv[2];
    unsigned long miv[2];
    unsigned long* pi;
    unsigned long* po;

    memcpy(niv, iv, 8);
    pi = (unsigned long*)inbuf;
    po = (unsigned long*)outbuf;

    for (i = 0; i < length; i += 8) {
        miv[0] = pi[0];
        miv[1] = pi[1];
        Blowfish_Decrypt(pi, po, key);
        po[0] ^= niv[0];
        po[1] ^= niv[1];
        niv[0] = miv[0];
        niv[1] = miv[1];
        po += 2;
        pi += 2;
    }
}

