/*
 *  setup_bf.c
 * 
 *  Copyright 1997,8,9 2002 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/ppdd.h>

void setup_bf(struct ppdd_ukeys *ukeys, struct ppdd_keys *keys)
{
	int i;

	for(i = 0; i < PPDDNKEYS; i++) {
		Blowfish_ExpandUserKey(ukeys->encrypt_bkey[i], PPDDKEYSIZE, 
							keys->key[i]);
	}
        memcpy(keys->whitev, ukeys->whitev, sizeof(keys->whitev));
#ifdef __KERNEL__
        memcpy(keys->block0, ukeys->block0, 512);
        memcpy(keys->block1, ukeys->block1, 512);
#else
        memset(keys->block0, 0, 512);
        memset(keys->block1, 0, 512);
#endif
}

