#ifndef _LINUX_BF_H
#define _LINUX_BF_H

#ifndef __KERNEL__
#include <string.h>
#endif


/* The data block processed by the encryption algorithm - 64 bits */
typedef unsigned long Blowfish_Data[2];

/* The key as entered by the user - size may vary */
typedef char Blowfish_UserKey[16];

/* The expanded key for internal use - 18+4*256 words*/
typedef unsigned long Blowfish_Key[1042];

void Blowfish_Encrypt(const void *dataIn, void *dataOut, const void *key);
void Blowfish_Decrypt(const void *dataIn, void *dataOut, const void *key);
void Blowfish_ExpandUserKey(const void *userKey, const int userKeyLen, void *key);

void Blowfish_Encrypt_cbc(Blowfish_Key key, const unsigned char* iv,
                const unsigned char* inbuf, unsigned char* outbuf, int length);

void Blowfish_Decrypt_cbc (Blowfish_Key key, const unsigned char* iv,
                const unsigned char* inbuf, unsigned char* outbuf, int length);


void Blowfish_Encrypt_ecb(Blowfish_Key key, const unsigned char* inbuf,
                                          unsigned char* outbuf, int length);

void Blowfish_Decrypt_ecb(Blowfish_Key key, const unsigned char* inbuf,
                                          unsigned char* outbuf, int length);
#endif
