#ifndef _LINUX_PPDD_H
#define _LINUX_PPDD_H

/*
 *  include/linux/ppdd.h
 *
 *  Copyright 1997,8,9,2000 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 */

#include <linux/bf.h>

#define PP_NAME_SIZE	256
#define PP_VERSION	20
#define PPDDENCRYPT     0
#define PPDDDECRYPT     1
#define PPDDKEYSIZE     32
#define PPDDNKEYS       17
#define PPDDNWHITE      61
#define PPDDMKSIZE      (8 + PPDDKEYSIZE)

struct ppdd_ukeys {
        unsigned char   	md5_bkey[PPDDKEYSIZE];
        unsigned char           encrypt_bkey[PPDDNKEYS][PPDDKEYSIZE];
        unsigned long           whitev[PPDDNWHITE];
	unsigned char		block0[512];
	unsigned char		block1[512];
};

struct ppdd_keys {
        Blowfish_Key            key[PPDDNKEYS];
        unsigned long           whitev[PPDDNWHITE];
	unsigned char		block0[512];
	unsigned char		block1[512];
};

extern int transfer_bf(struct ppdd_keys *keys, int cmd,
                       const unsigned char *in8, unsigned char *out8,
                       int size, const unsigned long posf);

extern void setup_bf(struct ppdd_ukeys *ukeys, struct ppdd_keys *keys);

extern void ppdd_scramble(int, unsigned long const *, unsigned long*, 
			unsigned long, unsigned long, unsigned long);
extern void ppdd_unscramble(int, unsigned long const *, unsigned long*,
			unsigned long, unsigned long, unsigned long);

#endif
