/*
 * newpass.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>

#include "ppddmount.h"

int newpass(int fd, const char* ifile, unsigned char* ukey,
	struct crypt_control_block* cblock, int master)
{
	int		ok, len1, len2;
	unsigned char	passphrase1[136];
	unsigned char	passphrase2[136];
	Blowfish_Key 	bkey;
	unsigned char	temp1[PPDDMKSIZE];
	unsigned char	temp2[PPDDMKSIZE];
	unsigned char	key[PPDDKEYSIZE];

	if (master < 0){
	    ok = 1;
	} else {
	    if (fd < 0) {
	    	do {
		    ok = getnewpass(master, &len1, passphrase1, &len2,
								 passphrase2);
	    	} while (ok == 0);
	    	if (ok == -1) ok = 0;
	    } else {
                ok = find_ppdd_entry(fd, NULL, ifile, passphrase1 + 8,
						 passphrase2 + 8, NULL);
		len1 =  strlen(passphrase1 + 8);
		len2 =  strlen(passphrase2 + 8);
	    }
	}
	if (!ok) {
		printf("Failed to get new pass phrases\n\n");
		return (ok);
	}
	printf("Generating keys - please wait\n");
	if (ok) {
	    if (master) {
		if (master > 0) {
	    	    make_key(key, cblock->iv, &len1, passphrase1, 
						&len2, passphrase2);
		    memcpy(ukey, key, PPDDKEYSIZE);
		}

		ok = random_fill_fast (cblock->mkey, PPDDMKSIZE);

	    } else {
		make_key(key, cblock->iv, &len1, passphrase1, 
						&len2, passphrase2);
		memcpy(ukey, &cblock->mkey[4], PPDDKEYSIZE);
		Blowfish_ExpandUserKey(key, PPDDKEYSIZE, bkey);
		ok = random_fill_fast (temp1, PPDDMKSIZE);
		memcpy(&temp1[4], &cblock->mkey[4], PPDDKEYSIZE);
		Blowfish_Encrypt_ecb(bkey, temp1, temp2, PPDDMKSIZE);
		Blowfish_ExpandUserKey(ukey, PPDDKEYSIZE, bkey);
		Blowfish_Decrypt_ecb(bkey, temp2, cblock->mkey, PPDDMKSIZE);
	    }
	    ok = random_fill_fast(cblock->x4,sizeof(cblock->x4));
	    make_crc(cblock,PPDD_CRC_MAKE);
	}
	memset(temp1, 0, PPDDMKSIZE);
	memset(temp2, 0, PPDDMKSIZE);
	memset(bkey, 0, sizeof(bkey));
	memset(key, 0, PPDDKEYSIZE);
	memset(passphrase1, 0, sizeof(passphrase1));
	memset(passphrase2, 0, sizeof(passphrase2));
        len1 = len2 = 0;
	return (ok);
}
