/*
 *  ppdd_scramble.c
 * 
 *  Copyright 1997,8,9 2002 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/ppdd.h>
#include "mix.h"

void ppdd_scramble(int size, const unsigned long *in, unsigned long *out,
			unsigned long a, unsigned long b, unsigned long c)
{
    int i,j,k;

    j = size - 2;
    k = size - 1;
 
    for (i = 0; i < j; i += 3) {
        out[i]   = a += in[i];
        out[i+1] = b += in[i+1];
        out[i+2] = c += in[i+2];
        mix(a, b, c);
    }
    out[j] = b + in[j];
    out[k] = b + in[k];
}

