/*
 * ppddmchk.c - check if a file is on a given device
 *
 * Copyright 1998,9, 2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 * typical use is in rc.sysinit or similar scripts where
 * you need to know if the root is on a ppdd device or not
 *
 * e.g. ppddmchk / /dev/loop0
 *
 * 	returns 0 if / is on /dev/ppdd0
 */

#include <stdio.h>
#include <sys/stat.h>

int main (int argc, char **argv) 
{
	FILE *fd;
	struct stat stats_1;
	struct stat stats_2;

	if (argc != 3) return(1);

	if (stat(argv[1],&stats_1)) {
		return 1;
	}

	if (stat(argv[2],&stats_2)) {
		return 1;
	}

	return((stats_1.st_dev != stats_2.st_rdev));

}
