/*
 * random_fill_fast.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>

#include "ppddmount.h"

int random_fill_fast (void *block, int size)
{
	char		*progname = "random_fill_fast";
	int 		i, urfd;
	Blowfish_Key 	bkey;
	unsigned char 	seed[512];
	unsigned char 	ckey[3];
	time_t		key;
	unsigned char 	*pk;
	unsigned long 	xs[3];
 	fd_set 		rfds;
 	struct timeval 	tv;

/* open the fast random file */

	if ((urfd = open ("/dev/urandom", O_RDWR)) < 0) {
		PPDDERROR(201)
		return 0;
	}

	if (size & 7) {
	    if (read (urfd, block, size) != size) {
		PPDDERROR(203)
		close (urfd);
		return 0;
	    }
	    close (urfd);
	    return 1;
	}

/* get 512 bytes as seed */

	if (read (urfd, seed, 512) != 512) {
		PPDDERROR(204)
		close (urfd);
		return 0;
	}

/* this adds an element of unpredictability */

	key = time(NULL);

	Blowfish_ExpandUserKey(&key, sizeof(key), bkey);
	Blowfish_Encrypt_ecb(bkey, seed, seed, 512);

/* reset 512 bytes as seed */

	if (write (urfd, seed, 512) != 512) {
		PPDDERROR(205)
	        close (urfd);
		return 0;
	}

	pk = malloc(size);
	if (pk == NULL) return 1;

/* fill the scramble seed with random bytes */

	if (read (urfd, xs, sizeof(xs)) != sizeof(xs)) {
		PPDDERROR(206)
	        close (urfd);
		return 0;
	}

/* fill the block with random bytes */

	if (read (urfd, block, size) != size) {
		PPDDERROR(210)
	        close (urfd);
		return 0;
	}

/* scramble the block into *pk */

	ppdd_scramble((size >> 2), (unsigned long*)(block), (unsigned long*)pk,
				xs[0], xs[1], xs[2]); 


/* fill the block with random bytes again */

	if (read (urfd, block, size) != size) {
		PPDDERROR(211)
	        close (urfd);
		return 0;
	}

	close (urfd);

/* now some real random, but only a few bytes in case it stalls */

	if ((urfd = open ("/dev/random", O_RDONLY)) < 0) {
		PPDDERROR(212)
		return 0;
	}

	for(i=0;i<sizeof(ckey);) {

/* the real random device often waits before giving us a character
   so lets use this delay to mash up the random data we already have */

		key = time(NULL);
		tv.tv_usec = 10000 * (key % 100);
		tv.tv_sec = 0;

  		FD_ZERO(&rfds);
  		FD_SET(urfd, &rfds);
  		select(urfd+1, &rfds, NULL, NULL, &tv);
  		if (FD_ISSET(urfd, &rfds))
  		{
			if (read (urfd, ckey+i, 1) != 1) {
				PPDDERROR(213)
				return 0;
			}
			i++;
			Blowfish_ExpandUserKey(&tv.tv_usec,
						sizeof(tv.tv_usec), bkey);
		} else {
			Blowfish_Encrypt_ecb(bkey, block, block, size);
		}
	}

	close (urfd);

	Blowfish_ExpandUserKey(&key, sizeof(key), bkey);
	Blowfish_Encrypt_ecb(bkey, block, block, size);

/* add the results */

	for(i=0;i<size;i++) {
		((unsigned char*)block)[i] ^= ~pk[i];
	}

	memset(pk, 0, size);
	free(pk);

	memset(seed, 0, 512);
	memset(&key, 0, sizeof(key));
	memset(ckey, 0, sizeof(ckey));
	memset(bkey, 0, sizeof(bkey));

	return 1;
}
