/*
 *  random_fill_slow.c
 *
 * Copyright 1998,1999,2000,2002 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/termios.h>

#include "ppddmount.h"

int random_fill_slow (void *block, int size)
{
	char		*progname = "random_fill_slow";
	int 		ok,done,i, rfd;
	unsigned char 	k,r,s;
	unsigned char 	*pk;
	fd_set 		rfds;
	struct termios 	otios;
	struct termios 	ntios;
	struct timeval 	tv;
	unsigned long 		xs[6];

/* we want to turn off echo so get the terminal flags */

	tcgetattr(0, &otios);
	tcgetattr(0, &ntios);

	ntios.c_lflag &= ~(ECHO|ICANON);

/* echo now turned off */

	tcsetattr(0, TCSANOW, &ntios);

/* we are going to use the Linux real random device  */

	if ((rfd = open ("/dev/random", O_RDONLY)) < 0) {
		PPDDERROR(214)
		return 0;
	}

/* whatever we were given in the block now gets scrambled */

	ok = random_fill_fast (xs, sizeof(xs));
	if (!ok) return 0;

	pk = malloc(size);
	if (pk == NULL) return 0;

	ppdd_scramble((size >> 2), (unsigned long*)(block), (unsigned long*)pk,
				xs[0], xs[1], xs[2]); 

	ppdd_scramble((size >> 2), (unsigned long*)pk, (unsigned long*)(block),
				xs[3], xs[4], xs[5]); 

	memset(pk, 0, size);
	memset(xs, 0, sizeof(xs));

	free(pk);

	printf("Generating keys: %d bytes needed.\n\n", size);
	printf("    Enter random characters on the keyboard.\n");
	printf("    If you get bored turn caps lock on and off a few times.\n\n");
	printf("    Don't hold the keys down.\n\n");

	pk = block;
	s = 0;
	done = 0;

	for (i=size;i > 0;) {
 	    FD_ZERO(&rfds);
	    FD_SET(0, &rfds);
	    FD_SET(rfd, &rfds);
	    select(rfd+1, &rfds, NULL, NULL, NULL);
	    if (FD_ISSET(rfd, &rfds)) {
	        if (read (rfd, &k, 1) != 1) {
		    PPDDERROR(215)
		    return 0;
		}

/* add the random byte we get on top of what we already have */

	       	*pk ^= ~k;
		done = 1;
	    }
	    if (FD_ISSET(0, &rfds)) {
	        if (read (0, &r, 1) != 1) {
		    PPDDERROR(216)
		    return 0;
		}

/* if the user holds a key down or if we haven't had a random
   byte generated in this time then don't step along */

		if (r != s) {
		    s = r;

/* step along the block - one step per character entered
   there will usually be several random characters generated
   in this time - if not then we don't step along yet */

		    if (done) {

/* use the input character itself to rotate the random byte */

			r &= 7;
			*pk = ((*pk << r) | (*pk >> (8 - r)));

		        pk++;
		        done = 0;
		    	if ((i & 63) == 0) {
                	    printf("    Keep going: only %d left to generate!\n",i);
		    	}
			i--;
		    }
		}
	    }
        }

        close(rfd);

        printf("\nDone! You can rest your fingers now.\n\n");

/* we now want to flush any typed ahead characters */

	tv.tv_sec = 2;
	tv.tv_usec = 0;

	done = 0;

	while (!done) {
		FD_ZERO(&rfds);
		FD_SET(0, &rfds);
		select(1, &rfds, NULL, NULL, &tv);
		done = 1;
		if (FD_ISSET(0, &rfds)) {
		    if (read (0, &r, 1) != 1) {
		        PPDDERROR(218)
			return 0;
		    }
		    done = 0;
		}
	}

/* and now reset the terminal as it was before */

	tcsetattr(0, TCSANOW, &otios);
	return 1;
}
