/*
SHA-1 in C
By Steve Reid <steve@edmweb.com>
100% Public Domain
*/

#ifndef __SHA1_H
#define __SHA1_H

typedef struct {
    unsigned long state[5];
    unsigned long count[2];
    unsigned char buffer[64];
} SHA1_CTX;

void SHA1Transform(unsigned long state[5], unsigned char buffer[64]);
void SHA1_Init(SHA1_CTX* context);
void SHA1_Update(SHA1_CTX* context, unsigned char* data, unsigned int len);
void SHA1_Final(unsigned char digest[20], SHA1_CTX* context);

#endif /* __SHA1_H */
