/*
  Licensed under the GNU Public License.
  Copyright (C) 1998-99 by Thomas M. Vier, Jr. All Rights Reserved.

  wipe is free software.
  See LICENSE for more information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* conditional defines */

#ifdef STAT_MACROS_BROKEN
/* just in case, so we don't unlink a directory,
   we don't currently handle broken stat macros */
# define unlink(x) remove(x)
#endif

#ifndef HAVE_UNLINK
# define unlink(x) remove(x)
#endif

#ifndef HAVE_RMDIR
# define rmdir(x) remove(x)
#endif

#ifndef HAVE_BZERO
# define bzero(x, y) memset(x, 0, y)
#endif

#undef SYNC
#ifdef HAVE_FDATASYNC
# define SYNC

/* this proto is needed for glibc2, even though it's already in
 * unistd.h, cuz for some reason, it wasn't being properly included
 */
extern int fdatasync  (int __fildes)    ; /* copied from unistd.h */

#elif HAVE_FSYNC
# define SYNC
#endif

#ifdef SYNC
# ifndef HAVE_FDATASYNC
#  ifdef HAVE_FSYNC
#   define fdatasync(fd) fsync(fd)
#  endif
# endif
#endif

#undef LOCKABLE
#ifdef HAVE_FCNTL
# define LOCKABLE
#elif HAVE_LOCKF
# define LOCKABLE
#elif HAVE_FLOCK
# define LOCKABLE
#endif
