/*
  Licensed under the GNU Public License.
  Copyright (C) 1998-99 by Thomas M. Vier, Jr. All Rights Reserved.

  wipe is free software.
  See LICENSE for more information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* conditional includes */
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#else
# undef HAVE_FCNTL
#endif

#ifndef HAVE_FCNTL
# ifndef HAVE_LOCKF
#  ifdef HAVE_FLOCK
#   ifdef HAVE_SYS_FILE_H
#    include <sys/file.h>
#   else
#    undef HAVE_FLOCK
#   endif
#  endif
# endif
#endif

#ifdef HAVE_IOCTL
# ifndef HAVE_SYS_IOCTL_H
#  undef HAVE_IOCTL
# endif
#endif

#ifdef HAVE_IOCTL
# include <sys/ioctl.h>
# undef LINUXBLKDEV
# undef BSDBLKDEV
# ifdef LINUX
#  ifdef HAVE_LINUX_FS_H
#   include <linux/fs.h>
#   define LINUXBLKDEV
#  endif
# else /* assume everything else is BSD */
#  ifdef HAVE_SYS_DISKLABEL_H
#   include <sys/disklabel.h>
#   define BSDBLKDEV
#  endif
# endif /* LINUX */
# ifdef BSDBLKDEV
#  ifdef LINUXBLKDEV
#   error wtf? LINUXBLKDEV and BSDBLKDEV conflict
#  endif
# endif
#endif /* HAVE_IOCTL */

#ifdef HAVE_MMAP
# ifdef HAVE_SYS_MMAN_H
#  define MMAP
#  include <sys/mman.h>
# endif
#endif

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

#ifdef HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen)
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef HAVE_LINUX_FS_H
# include <linux/fs.h>
#endif

#ifndef PATH_MAX
# define PATH_MAX 4095
#endif

#ifndef NAME_MAX
# define NAME_MAX 1023
#endif
