/*
  require.h

  Licensed under the GNU Public License.
  See LICENSE for more information.
  wipe is free software.

  minimum requirements for wipe
*/

#ifndef HAVE_UNISTD_H
# error missing include: unistd.h
#endif

#ifndef HAVE_TIME_H
# error missing include: time.h required
#endif

#ifndef HAVE_SYS_STAT_H
# error missing include: sys/stat.h required
#endif

#ifndef HAVE_SYS_TYPES_H
# error missing include: sys/types.h required
#endif

#ifndef HAVE_SYS_TIME_H
# error missing include: sys/time.h required
#endif

#ifndef HAVE_ERRNO_H
# error missing include: errno.h required
#endif

#ifndef HAVE_FDATASYNC
# ifndef HAVE_FSYNC
# error missing function: fsync() or fdatasync() required
# endif
#endif

#ifndef HAVE_FSYNC
# ifndef HAVE_FCNTL
#  error missing function: fsync() or fcntl() required
# endif
#endif

#ifndef HAVE_GETOPT
# error missing function: getopt() required
#endif

#ifndef HAVE_MEMSET
# error missing function: memset() required
#endif

#ifndef HAVE_MEMCPY
# error missing function: memcpy() required
#endif

#ifndef HAVE_REALLOC
# error missing function: realloc() required
#endif

#ifndef HAVE_UNLINK
# ifndef HAVE_REMOVE
#  error missing function: unlink() or remove() required
# endif
#endif

#ifndef HAVE_RMDIR
# ifndef HAVE_REMOVE
#  error missing function: rmdir() or remove() required
# endif
#endif

#ifndef HAVE_UNLINK
# ifndef HAVE_REMOVE
#  error missing function: unlink() or remove() required
# endif
#endif

#ifndef HAVE_RENAME
# error missing functions: rename() required
#endif
