/*
  Licensed under the GNU Public License.
  Copyright (C) 1998-99 by Thomas M. Vier, Jr. All Rights Reserved.

  wipe is free software.
  See LICENSE for more information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* structs */

/* percent data */
struct complete
{
  float complete;               /* percentage of wipe completion             */
  float increment;              /* add to percentage after each pass         */
  unsigned int display:1;       /* show percentage                           */
  unsigned int reported:1;      /* set if percentage was reported            */
};

/* command line options */
struct opt
{
  unsigned int mmap:1;          /* memory map files if true                  */
  unsigned int hash:1;          /* use /dev/urandom hash if true             */
  unsigned int verbose:2;       /* verbose level                             */
  unsigned int recursion:1;     /* traverse directories if true              */
  unsigned int zero:1;          /* zero-out file                             */
  unsigned int force:1;         /* force wipes -- override interaction       */
  unsigned int delete:1;        /* remove targets if true                    */
  unsigned int custom:1;        /* wipe file with user specified byte        */
  unsigned int random:1;        /* perform random passes if true             */
  unsigned int seclevel:2;      /* secure level                              */
  unsigned int interactive:1;   /* prompt for each file                      */
  unsigned int random_loop:5;   /* how many times to loop the random passes  */
  unsigned int wipe_multiply:5; /* how many times to loop all 35 passes      */
};
