/*****************************************************
*                                                    *
*  File encryption using the threeway block cipher   *
*                                                    *
*                                                    *
*         Copyright (C) 1998 Carl van Schaik         *
*                            (carl@leg.uct.ac.za)    *
******************************************************/

#include "3way.h"
#include "getpass.c"
#include <stdlib.h>
#include <stdio.h>

#define maxBufLen  12288

extern int encrypt_3_way(word96, word8*, word32);
extern int decrypt_3_way(word96, word8*, word32);
extern void init_3way();

FILE *inFile;        /* file with input data (plain or ciphertext)  */
FILE *outFile;       /* file for output data (plain or ciphertext)  */

int enc = 0;    /* we want encryption */
int dec = 0;    /* we want decryption */
int ser = 0;    /* we want to show key's hex value */
word96 pKey;

char   databuf[maxBufLen];
word32 datalen;

void getKey_3way()
{
  char *buf;
  word96 tKey;
  int i=0;

  printf("  Every keypress is recorded, delete/backspace are taken as characters\n");
  printf("  Enter Key/Password : ");
  buf = getPass();

  tKey[0] = tKey[1] = tKey[2] = 1;

  while ((i < 128) && (buf[i] != '\n'))
    {
      tKey[0] += buf[i]*i;
      tKey[1] += (buf[1]<<2)*i;
      tKey[2] *= buf[i];
      i++;
    }

  pKey[0] = pKey[1] = pKey[2] = 0;

  encrypt_3_way(tKey,(word8*)pKey,12);

  if (ser)
    {
#ifdef __alpha
      printf("Serial number = 0x%08x%08x%08x",pKey[0],pKey[1],pKey[2]);
#else
      printf("Serial number = 0x%08lx%08lx%08lx\n",pKey[0],pKey[1],pKey[2]);
#endif
    }
}

void ReadOptions(char *str)
{
  char ch;
  str++;
  while((ch = *str++) != '\0') {
    switch (ch) {
      case 'e': enc=1; break;
      case 'd': dec=1; break;
      case 's': ser=1; break;
      default: break;
    }
  }
} /* ReadOptions */

void getData()
{
  datalen = fread(databuf, 1, maxBufLen, inFile);
}

void putData()
{
  fwrite(databuf, 1, datalen, outFile);   
}

void writeHeader_3way()
{
  datalen=12;
  databuf[0]=pKey[0];
  databuf[1]=pKey[0]>>8;
  databuf[2]=pKey[0]>>16;
  databuf[3]=pKey[0]>>24;
  databuf[4]=pKey[1];
  databuf[5]=pKey[1]>>8;
  databuf[6]=pKey[1]>>16;
  databuf[7]=pKey[1]>>24;
  databuf[8]=pKey[2];
  databuf[9]=pKey[2]>>8;
  databuf[10]=pKey[2]>>16;
  databuf[11]=pKey[2]>>24;

  encrypt_3_way(pKey,databuf,12);

  putData();
}

int getHeader_3way()
{
  datalen = fread(databuf, 1, 12, inFile);
  decrypt_3_way(pKey,databuf,12);

  if (datalen==12)
    {
      if (databuf[0]==(char)pKey[0] &&
	  databuf[1]==(char)(pKey[0]>>8) &&
	  databuf[2]==(char)(pKey[0]>>16) &&
	  databuf[3]==(char)(pKey[0]>>24) &&
	  databuf[4]==(char)(pKey[1]) &&
	  databuf[5]==(char)(pKey[1]>>8) &&
	  databuf[6]==(char)(pKey[1]>>16) &&
	  databuf[7]==(char)(pKey[1]>>24) &&
	  databuf[8]==(char)(pKey[2]) &&
	  databuf[9]==(char)(pKey[2]>>8) &&
	  databuf[10]==(char)(pKey[2]>>16) &&
	  databuf[11]==(char)(pKey[2]>>24)
	  )
	return 0;
      else
	  return 1;
    }
  else
      return 1;
}

void main(int argc, char *argv[])
{
  argc--;
  argv++;

  printf("File encryption using 96-bit 3-way high security cipher.\n");
  printf("This program is not from the US. It's free software.\n");
  printf("Copyright (C) 1998 Carl van Schaik, UCT, South Africa\n");

  while (argc > 0 && argv[0][0] == '-' && argv[0][1] != '\0')
    {
      ReadOptions(*argv++);
      argc--;
    }

  inFile = fopen(*argv++, "rb"); argc--;
  if (inFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  outFile = fopen(*argv++, "wb"); argc--;
  if (outFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  init_3way();

  if (enc)
    {
      getKey_3way();

      printf("Encrypting...\r");
      fflush(stdout);

      writeHeader_3way();
      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  encrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  encrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      printf("Finished     \n");
    }
  else if (dec)
    {
      getKey_3way();

      printf("Decrypting...\r");
      fflush(stdout);

      if (getHeader_3way())
	{
	  argv--; argv--;
	  printf("File \"%s\" is not encrypted or wrong password\n",*argv);
	  exit(0);
	}

      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  decrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  decrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
       printf("Finished     \n");
   }
  else
    {
      printf("Usage: ");
      printf("crypt -[e|d] [-s] inFile outFile\n");
      printf("  The key will be asked for before encryption/decryption\n");
      printf("  -e   Encrypt input File\n");
      printf("  -d   Decrypt input File\n");
      printf("  -s   Show serial number (Hex derivation of key)\n");
    }
}
