/*
 *  crypt_funcs.h
 *
 *  Cryptographic Functions to be used in
 *  The Steganographic File System (sfs)
 *  Encryption Routines
 *
 *  Copyright (C) 1998
 *  Paul Smeddle (psmeddle@cs.uct.ac.za)
 *  Carl van Schaik (carl@leg.uct.ac.za)
 *  University of Cape Town, South Africa
 *
 */

#ifndef CRYPT_FUNCS
#define CRYPT_FUNCS

#include "3way.h"
#include "idea.h"

extern int encrypt_3_way(word96, word8*, word32);
extern int decrypt_3_way(word96, word8*, word32);
extern void init_3way();

extern int encrypt_idea(Idea_UserKey, word8*, word32);
extern int decrypt_idea(Idea_UserKey, word8*, word32);

extern void make_3way_key(char* text_key, word96 three_way_key);
extern void make_idea_key(char* text_key, Idea_UserKey idea_user_key);

#endif
