/* vs3lib.h - Common functions shared by the steganographic
 *            filesystem
 *
 * Copyright (C) 1998 Carl van Schaik (carl@leg.uct.ac.za)
 *                    Paul Smeddle (psmeddle@cs.uct.ac.za)
 * SFS - [S]teganographic [F]ile [S]ystem
 *
 *
 * %Begin-Header%
 * This file may be redistributed under the terms of the GNU Public
 * License.
 * %End-Header%
 *
 * Note, the position of the "crypt_master" block is located by taking
 * (e_three_way_key[0] % (blocks on disk))
 */


#ifndef SFS_LIB_STEG
#define SFS_LIB_STEG

#include "crypt_funcs.h"
#include "rand.h"

extern char    *device_name;

/* Command line options */
extern int got_device;
extern int wants_key;
extern int show_stats;

/* Encryption Stuff */
Idea_UserKey idea_key, e_idea_key;
word96       three_way_key, e_three_way_key;

/* System Stuff */
extern char *volume_label;
unsigned char text_key[128];
struct sfs_super_block sb;

char bitmap[SFS_BLK];
extern unsigned int offset;
typedef int handle;
handle   device;

extern void clean_up();
extern void die(char*);
extern void check_mount();
extern void write_block(unsigned int, char *);
extern void write_e_block(unsigned int, char *);
extern void write_data_block(unsigned int, char *);
extern void write_e_data_block(unsigned int, char *);
extern void read_block(unsigned int, char *);
extern void read_e_block(unsigned int, char *);
extern void read_data_block(unsigned int, char *);
extern void read_e_data_block(unsigned int, char *);
extern void bitset(char[],int);
extern void bitunset(char[],int);
extern int is_bit_set(char[],int);
extern int sfs_verify(struct sfs_super_block);
extern int sfs_verify_i(struct sfs_inode);
extern void update_super_block(struct sfs_super_block);
extern int is_block_used(unsigned int);
extern void set_block_used(unsigned int);
extern void sync_super_blocks();
extern char* read_dir(struct sfs_inode);
extern void update_dir(char*,struct sfs_inode);
extern unsigned int get_size();
extern int check_device();
extern void ask_for_key(char);
extern void get_fs_info();

#endif
