/*
 *  linux/fs/vs3_fs/dir.c
 *
 * Copyright (C) 1998
 * Paul Smeddle (psmeddle@cs.uct.ac.za)
 * Carl van Schaik (carl@leg.uct.ac.za)
 * University of Cape Town, South Africa
 *
 *  from
 *
 *  src/linux/fs/minix/dir.c
 */

/*
 *  Note that when talking about the "encrypted" somthing
 *  we are talking about whatever the user has hidden
 *  with a password other than with the default password.
 *  All other things are encrypted with only the default
 *  password.
 */

/* dir.c - Carl van Schaik */

#define __KERNEL__
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/malloc.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/vs3_fs.h>
#include <linux/stat.h>
 
int vs3_readdir(struct inode * dir, struct file * filp,
	void * dirent, filldir_t filldir)
{
	struct vs3_dir_entry * de;
	struct vs3_sb_info * info;
        char * buffer;
	int size, count=0;

	if (!dir || !dir->i_sb || !S_ISDIR(dir->i_mode))
		return -EBADF;
	info = &dir->i_sb->u.vs3_sb;
 
        size = dir->u.vs3_i.i_dir_entries;
	if (filp->f_pos >= size)
	  return 0;

        buffer = vs3_read_dir_low(dir);
        if (buffer == NULL)
           return 0;

        de = (struct vs3_dir_entry *)(buffer);
	while (count < filp->f_pos)
	{
	   de = (struct vs3_dir_entry *)((char*)de + de->rec_len);
	   count ++;
	}
	while ((count < size) && (filp->f_pos < 4096))
           {
              if (de->inode_p)
                 {
                    if (filldir(dirent, de->name, de->name_len, filp->f_pos, de->inode_p) < 0)
                       {
                          kfree(buffer);
			  filp->f_pos++;
                          return 0;
                       }
                 }
	      else
		printk("vs3_readdir: Bad directory entry\n");
              filp->f_pos ++;
	      count ++;

              de = (struct vs3_dir_entry *)((char*)de + de->rec_len);
           }

        if (dir->i_sb->u.vs3_sb.user_key_in_use)
           if (dir->i_ino == dir->i_sb->u.vs3_sb.s_root_ptr)
              {
                 if (filldir(dirent, "secret", 6, filp->f_pos, dir->i_sb->u.vs3_sb.s_crypt_master->cm_root_ptr) < 0)
                 {
                    kfree(buffer);
                    return 0;
                 }
              }


/*	UPDATE_ATIME(inode);*/
        kfree(buffer);
	return 0;
}
