/*
 *  linux/include/linux/truncate.c
 *
 * The Steganographic Filesystem (vs3fs)
 *
 *   Copyright (C) 1998
 *   Paul Smeddle (psmeddle@cs.uct.ac.za)
 *   Carl van Schaik (carl@leg.uct.ac.za)
 *   University of Cape Town, South Africa
 *
 * Portions (C) from ext2 / minix filesystems
 */


#define __KERNEL__
#include <linux/sched.h>
#include <linux/fs.h>
#include <linux/vs3_fs.h>

/* this clears a disk block in the block bitmaps and inode pointers */
void vs3_remove_ptr( struct inode *i, __u32 blockno )
{
	set_block_free( i->i_sb, vs3_find_block(i,blockno) );
}

/* This is the actual truncate function. Separation for readability and
   race-condition handling. Race condition handling is incomplete. Also, 
   function only truncates up to end of i_direct. */
 
int vs3_trunc( struct inode *i ) {
	struct vs3_inode *raw;
	__u32 from_block, to_block, loop;
	struct buffer_head *bh;
	
	bh = vs3_bread( i, i->i_ino, i->u.vs3_i.enc_mode );
	if( !bh ) {
			printk( "vs3fs_truncate: unable to read inode block\n" );
			return 0;
		}
/*	if( bh->b_count != 1 )
	{
	   vs3_bforget(bh);
	   printk("truncate: buffer in use\n");
	   return 1;
	}*/
	raw = (struct vs3_inode *)bh->b_data;
	from_block = i->i_size / VS3_BLK;
	to_block = raw->i_file_size / VS3_BLK;
	for( loop = to_block; loop > from_block; loop-- ) {
		vs3_remove_ptr( i, loop );
	}
	raw->i_file_size = i->i_size;
	vs3_bwrite( bh, i, i->u.vs3_i.enc_mode );			
	return 0;
}

/* This is the truncate function pointed to in multiple places in the VFS
 */
 
void vs3_truncate( struct inode *i )
{
	static int retry;
	
	if( !( S_ISREG( i->i_mode ) || S_ISDIR( i->i_mode ) ) ) return;
	
	do
	{
		retry = vs3_trunc( i );
		if( retry == 2 ) {
			printk( "vs3fs: fatal error tuncating inode.\n" );
			return;
		}
	} while( retry );
		
	i->i_mtime = i->i_ctime = CURRENT_TIME;
	i->i_dirt = 1;
}
