/*
 *  linux/include/linux/vs3_fs_sb.h
 *
 * Copyright (C) 1998
 * Paul Smeddle (psmeddle@cs.uct.ac.za)
 * Carl van Schaik (carl@leg.uct.ac.za)
 * University of Cape Town, South Africa
 *
 * From ext2_fs_sb.h
 *
 */

#ifndef _LINUX_VS3_FS_SB
#define _LINUX_VS3_FS_SB

#include <linux/types.h>

/*
 * VS3FS superblock structure in memory ( VFS )
 */

struct vs3_sb_info {
	__u32 s_free_blocks;
	__u32 s_block_total;
	__u32 s_first_block;
	__u32 s_default_uid;
	__u32 s_default_gid;
	__u32 s_root_ptr;
	__u32 s_bad_inode;
	__u32 s_group_no;
	struct vs3_crypt_master *s_crypt_master;
	struct buffer_head *s_cm_bh;
	struct buffer_head *s_bh;
	struct vs3_super_block *s_vs;
        __u32 three_way_key[3];
        __u32 e_three_way_key[3];
 	__u16 idea_key[16];
        __u16 s_magic_number;
	__u16 e_idea_key[16];
	__u8  user_key_in_use;
};

#endif
