/************************************************************************\
*                                                                        *
*  C specification of the Threeway Block Cipher                          *
*                                                                        *
*  3-Way is an iterated block cipher by Joan Daemen. It uses 96 bits for *
*  its keyspace and block size. There is no known successful             *
*  cryptanalysis against 3-way, and it is free for use.                  *
*                                                                        *
*  Steganographic Filesystem (C) 1998 Carl van Schaik                    *
*                                     Paul Smeddle                       *
\************************************************************************/

#ifndef THREE_WAY_H
#define THREE_WAY_H


#ifdef __alpha  /* Any other 64-bit machines? */
typedef unsigned int word32;
#else
typedef unsigned long word32;
#endif

/* the program only works correctly if long = 32bits */


typedef word32 word96[3];
typedef unsigned char word8;

#endif
