/*****************************************************
*                                                    *
*  File encryption using the threeway block cipher   *
*                                                    *
*    This program is free to use, and since it was   *
*    not written in the US, does not violate any     *
*    US encryption export laws                       *
*                                                    *
*         Copyright (C) 1998 Carl van Schaik         *
*                                                    *
******************************************************/

#include <stdio.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <termio.h>

#define TTYf       "/dev/tty"

#include <termios.h>
#define STTY(fd, termio) tcsetattr(fd, TCSANOW, termio)
#define GTTY(fd, termio) tcgetattr(fd, termio)
#define TERMIO struct termios

FILE *tty;

void setup_tty()
{
  TERMIO  termio;

  GTTY (0, &termio);              /* get terminal characteristics */

  termio.c_oflag |= ONLCR;
  termio.c_lflag &= ~(ECHO);

  STTY (0, &termio);
}

void fix_tty()
{
  TERMIO  termio;

  GTTY (0, &termio);              /* get terminal characteristics */

  termio.c_lflag |= ECHO;

  STTY (0, &termio);
}

char* getPass()
{
  static char buf[128];
  int i=0;

  setup_tty();
  if ((tty = fopen(TTYf,"r+")) == NULL)
    {
      printf("getpass: cannot read key from %s\n",TTYf);
      exit(1);
    }

  buf[0] = fgetc(tty);
  while (buf[i] != '\n')
    {
      i++;
      buf[i] = fgetc(tty);
      printf("*");
    }
  i++;
  buf[i] = '\0';
  printf("\n");

  fix_tty();

  fclose(tty);
  return buf;
}
