/*****************************************************
*                                                    *
*  File encryption using the IDEA block cipher       *
*                                                    *
*                                                    *
*         Copyright (C) 1998 Carl van Schaik         *
*                                                    *
******************************************************/

#include "idea.h"
#include "getpass.c"
#include <stdlib.h>
#include <stdio.h>

#define maxBufLen  8192

extern int encrypt_idea(Idea_UserKey, u_int8*, u_int32);
extern int decrypt_idea(Idea_UserKey, u_int8*, u_int32);

FILE *inFile;        /* file with input data (plain or ciphertext)  */
FILE *outFile;       /* file for output data (plain or ciphertext)  */

int enc = 0;    /* we want encryption */
int dec = 0;    /* we want decryption */
int ser = 0;    /* we want to show key's hex value */
Idea_Key pKey;

char   databuf[maxBufLen];
u_int32 datalen;

void getKey_idea()
{
  char *buf;
  int i=0;
  u_int32 val;

  printf("  Every keypress is recorded, delete/backspace are taken as characters\n");
  printf("  Enter Key/Password : ");
  buf = getPass();


  pKey[0]=pKey[1]=pKey[2]=pKey[3]=0;
  val=0;
  while (buf[i] != '\n')
    {
      val += (u_int32)buf[i] * i;
      pKey[i%4] += (u_int16)(val & 0xFFFF);
      val >>= 16;
      i++;
    }

  if (ser)
    printf("Serial number = 0x%08x%08x%08x%08x\n",pKey[0],pKey[1],pKey[2],pKey[3]);
}

void ReadOptions(char *str)
{
  char ch;
  str++;
  while((ch = *str++) != '\0') {
    switch (ch) {
      case 'e': enc=1; break;
      case 'd': dec=1; break;
      case 's': ser=1; break;
      default: break;
    }
  }
} /* ReadOptions */

void getData()
{
  datalen = fread(databuf, 1, maxBufLen, inFile);
}

void putData()
{
  fwrite(databuf, 1, datalen, outFile);   
}

void main(int argc, char *argv[])
{
  argc--;
  argv++;

  printf("File encryption using International Data Encryption Algorithm.\n");
  printf("This program is not from the US. It's free software.\n");
  printf("Copyright (C) 1998 Carl van Schaik, UCT, South Africa\n");

  while (argc > 0 && argv[0][0] == '-' && argv[0][1] != '\0')
    {
      ReadOptions(*argv++);
      argc--;
    }

  inFile = fopen(*argv++, "rb"); argc--;
  if (inFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  outFile = fopen(*argv++, "wb"); argc--;
  if (outFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  if (enc)
    {
      getKey_idea();

      printf("Encrypting...\r");
      fflush(stdout);

      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  encrypt_idea(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  encrypt_idea(pKey, databuf, datalen);
	  putData();
	}
      printf("Finished     \n");
    }
  else if (dec)
    {
      getKey_idea();

      printf("Decrypting...\r");
      fflush(stdout);

      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  decrypt_idea(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  decrypt_idea(pKey, databuf, datalen);
	  putData();
	}
       printf("Finished     \n");
   }
  else
    {
      printf("Usage: ");
      printf("crypt -[e|d] [-s] inFile outFile\n");
      printf("  The key will be asked for before encryption/decryption\n");
      printf("  -e   Encrypt input File\n");
      printf("  -d   Decrypt input File\n");
      printf("  -s   Show serial number (Hex derivation of key)\n");
    }
}
