/*
 *  linux/include/linux/stegfs_fs_i.h
 *
 * Copyright (C) 1999-2001
 * Andrew McDonald (andrew@mcdonald.org.uk)
 *
 *  from
 *
 *  linux/include/linux/ext2_fs_i.h
 *
 *  Copyright (C) 1992, 1993, 1994, 1995
 *  Remy Card (card@masi.ibp.fr)
 *  Laboratoire MASI - Institut Blaise Pascal
 *  Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs_i.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

#ifndef _LINUX_STEGFS_FS_I
#define _LINUX_STEGFS_FS_I

/* this is EXT2_N_BLOCKS * STEGFS_MAX_BLOCK_COPIES */
#define STEGFS_DATA_SIZE (15*14)
#define STEGFS_MAX_INO_COPIESX 28
#define STEGFS_MAX_BLOCK_COPIESX 14

/*
 * second extended file system inode data in memory
 */
struct stegfs_inode_info {
	__u32	i_flags;
	__u32	i_faddr;
	__u8	i_frag_no;
	__u8	i_frag_size;
	__u16	i_osync;
	__u32	i_file_acl;
	__u32	i_dir_acl;
	__u32	i_dtime;
	__u32	i_not_used_1;
	__u32	i_block_group;
	__u32	i_next_alloc_block;
	__u32	i_next_alloc_goal;
	__u32	i_prealloc_block;
	__u32	i_prealloc_count;
	__u32	i_high_size;
	__u8	i_icopies;
	__u8	i_bcopies;
	__u16	i_pref_bcopy;
	struct stegfs_inode_info2 *i_x;
	int	i_new_inode:1;	/* Is a freshly allocated inode */
};

struct stegfs_inode_info2 {
        __u32   i_data[STEGFS_DATA_SIZE];
        __u32   i_next_goal_block[STEGFS_MAX_BLOCK_COPIESX];
        __u32   i_inode[STEGFS_MAX_INO_COPIESX];
};

#endif	/* _LINUX_STEGFS_FS_I */
