/*
 *  linux/include/linux/stegfs_fs_sb.h
 *
 * Copyright (C) 1999-2001
 * Andrew McDonald (andrew@mcdonald.org.uk)
 *
 *  from
 *
 *  linux/include/linux/ext2_fs_sb.h
 *
 *  Copyright (C) 1992, 1993, 1994, 1995
 *  Remy Card (card@masi.ibp.fr)
 *  Laboratoire MASI - Institut Blaise Pascal
 *  Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs_sb.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

#ifndef _LINUX_STEGFS_FS_SB
#define _LINUX_STEGFS_FS_SB

#include "stegfs_fs.h"
#include <linux/config.h>

/*
 * The following is not needed anymore since the descriptors buffer
 * heads are now dynamically allocated
 */
/* #define EXT2_MAX_GROUP_DESC	8 */

#ifndef _LINUX_EXT2_FS_SB
#define EXT2_MAX_GROUP_LOADED	8
#endif

struct stegfs_sb_info2;

/*
 * second extended-fs super-block data in memory
 */
struct stegfs_sb_info {
	unsigned long s_frag_size;	/* Size of a fragment in bytes */
	unsigned long s_frags_per_block;/* Number of fragments per block */
	unsigned long s_inodes_per_block;/* Number of inodes per block */
	unsigned long s_frags_per_group;/* Number of fragments in a group */
	unsigned long s_blocks_per_group;/* Number of blocks in a group */
	unsigned long s_inodes_per_group;/* Number of inodes in a group */
	unsigned long s_itb_per_group;	/* Number of inode table blocks per group */
	unsigned long s_db_per_group;	/* Number of descriptor blocks per group */
	unsigned long s_desc_per_block;	/* Number of group descriptors per block */
	unsigned long s_groups_count;	/* Number of groups in the fs */
	/* struct buffer_head * s_sbh;*/	/* Buffer containing the super block */
	struct ext2_super_block * s_es;	/* Pointer to the super block in the buffer */
	struct buffer_head ** s_group_desc;
	unsigned short s_loaded_inode_bitmaps;
	unsigned short s_loaded_block_bitmaps;
	unsigned long s_inode_bitmap_number[EXT2_MAX_GROUP_LOADED];
	struct buffer_head * s_inode_bitmap[EXT2_MAX_GROUP_LOADED];
	unsigned long s_block_bitmap_number[EXT2_MAX_GROUP_LOADED];
	struct buffer_head * s_block_bitmap[EXT2_MAX_GROUP_LOADED];
	unsigned long  s_mount_opt;
	unsigned short s_resuid;
	unsigned short s_resgid;
	unsigned short s_mount_state;
	unsigned short s_pad;
	int s_addr_per_block_bits;
	int s_desc_per_block_bits;
	int s_inode_size;
	int s_first_ino;
	int s_feature_compat;
	int s_feature_incompat;
	int s_feature_ro_compat;
	struct stegfs_sb_info2 *s_x;
};


struct stegfs_sb_info2 {
#if defined(CONFIG_CIPHERS) || defined(CONFIG_CIPHERS_MODULE)
	struct cipher_implementation *s_ci;
#else
	struct stegfs_cipher * s_cipher;
#endif
#if defined(CONFIG_DIGEST) || defined(CONFIG_DIGEST_MODULE)
	struct digest_implementation *s_di;
#endif
	unsigned char *s_slkeys[STEGFS_MAX_LEVELS-1];
	char s_isstegfs;
	char * s_btabfname;
	struct dentry * s_btabfiled;
	struct file s_btabfile;
	unsigned short s_btabver;
	unsigned long s_last_alloc_ino[STEGFS_MAX_LEVELS-1];
	struct buffer_head * s_sbh;
};

#endif	/* _LINUX_STEGFS_FS_SB */
