/* Stegfs AES stubs */
/* Interfaces to Brian Gladman's AES implementation to avoid
   rewriting the existing AES finalists included in StegFS */

/* Copyright (c)2001 Andrew McDonald (andrew@mcdonald.org.uk) */
/* $Id: aesstub.c,v 1.1 2001/01/29 21:26:34 admcd Exp $ */

#include <stdlib.h>
//#include <unistd.h>

#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#include "aes.h"

char *aes_set_key(const char *cin_key, const unsigned int key_len) {
	unsigned int key_len2;
	aes *keyinfo;

	key_len2 = key_len / 32;
	keyinfo = (aes *)malloc(sizeof(aes));

	set_key(cin_key, key_len2, both, keyinfo);

	return (char *)keyinfo;
}


void aes_encrypt(const char *cl_key, const char *cin_blk, char *cout_blk) {

	encrypt(cin_blk, cout_blk, (aes *)cl_key);

}


void aes_decrypt(const char *cl_key, const char *cin_blk, char *cout_blk) {

	decrypt(cin_blk, cout_blk, (aes *)cl_key);

}
