/* StegFS - The Steganographic File System */
/* Copyright (c)1999 Andrew McDonald <andrew@mcdonald.org.uk> */
/* $Id: stegfsclose.c,v 1.2 1999/11/17 22:06:33 admcd Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <linux/stegfs_fs.h>

void printusage(char *);

int main(int argc, char *argv[]) {

	int fd, r, l, l2, i;
	struct stegfs_setlevel setlevel;
	char * pass;
	char * tmpc;

	if (argc < 2 || argc > 3)
		printusage(argv[0]);
	fd = open (argv[1], O_RDONLY|O_NONBLOCK);
	if (fd == -1)
		return -1;

	r = ioctl(fd, STEGFS_IOC_GETLEVELS, &l);
	if (r != 0) {
		perror("Error");
		exit(1);
	}

	/* close security level */

	setlevel.context = 0;

	if (argc == 2) {
		setlevel.level = 0;
	}
	else {
		setlevel.level = strtol(argv[2], &tmpc, 0);
		if (*argv[2] == '\0' || *tmpc != '\0' ||
		    setlevel.level < 0 ||
		    setlevel.level > STEGFS_MAX_LEVELS-1) {
			printf("Invalid security level number\n");
			exit(1);
		}
	}


/*
	printf("StegFS current level change %d to %d\n", l, setlevel.level);
*/

	setlevel.flags = 1;
	memset(setlevel.passw, 0, strlen(pass));

	r = ioctl(fd, STEGFS_IOC_SETLEVELS, &setlevel);
	if (r != 0) {
		perror("Error");
		exit(1);
	}

	/* double check */
	r = ioctl(fd, STEGFS_IOC_GETLEVELS, &l2);
	if (r != 0) {
		perror("Error");
		exit(1);
	}

	printf("Level change successful\n");

	printf("StegFS open levels:");
	r = 0;
	for (i=0; i<STEGFS_MAX_LEVELS-1; i++) {
		if ( (l2>>i) & 0x01 ) {
			printf(" %d", i+1);
			r = 1;
		}
	}
	if (r)
		printf("\n");
	else
		printf(" none\n");

	close(fd);
	exit(0);
}


void printusage(char *progname) {

  printf("Usage: %s /mnt/mntpoint [levelnum]\n",
	 basename(progname));

  exit(1);
}
