/* A useful tool */
/* Copyright (c)1999 ADM (andrew@mcdonald.org.uk) */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <string.h>
#include "stegfs.h"

int main(int argc, char *args[]) {

	char type;
	char data[1024];
	unsigned long int bnum, numb, i, j, k;
	struct stegfs_btable btab;
	struct stegfs_inode *sfsi;
	unsigned int *data32;
	struct ext2_dir_entry_2 *dent;
	char *key;
	struct stegfs_fs fs;
	struct stegfs_fs *fssys = &fs;
	unsigned int *xkey;
	int level;
	char *cipher;
	char *pass;

	if(argc < 6 || argc > 9) {
		printf("Usage: %s device btabfile level passphrase type "
		       "startblock [numblocks] [cipher]\n",
		       basename(args[0]));
		printf("type = u - unknown, i - stegfs inode, "
		       "d - directory block,\n");
		printf("n - indirection block\n");
		exit(1);
	}

	if(strlen(args[5]) != 1 || (args[5][0]!='u' && args[5][0]!='i' &&
				    args[5][0]!='n' && args[5][0]!='d')) {
		printf("unknown type\n");
		exit(1);
	}

	level = atoi(args[3]);
	if (level < 1 || level > STEGFS_MAX_LEVELS-1) {
		printf("bad level number\n");
		exit(1);
	}
	pass = args[4];
	type = args[5][0];
	bnum = strtoul(args[6],NULL,0);
	numb = argc>7 ? strtoul(args[7],NULL,0) : 1;
	cipher = argc>8 ? args[8] : "serpent";

	open_fs(fssys, args[1], args[2], cipher, 0);
	get_skeys(fssys, level, pass);

	xkey = (unsigned int *)(fssys->slkeys[level-1]);
	printf("key: %08x %08x %08x %08x\n",
	       xkey[0], xkey[1], xkey[2], xkey[3]);

	fseek(fssys->fsfile, bnum*1024, SEEK_SET);

	for(i=0; i<numb; i++) {

		get_btab(fssys, bnum+i, &btab);
		decrypt_btab(fssys, level, bnum+i, &btab);
		fread(data, 1024, 1, fssys->fsfile);
		decrypt_cbc(fssys, level, bnum+i, data, 1024, btab.iv);
		if(!(btab.magic1 == 0 &&
		     ((btab.magic2 == 0 && (type == 'u' || type == 'd' ||
					   type == 'n')) ||
		      (btab.magic2 == 1 && type =='i'))))
			printf("Warning: bad magic in block table entry\n");

		switch(type)
		{
		case 'u':
			for(j=0; j<1024; j++)
				printf("%c", data[j]);
			break;
		case 'i':
			sfsi = (struct stegfs_inode *)data;

			printf("mode = %o\n", sfsi->i_mode);
			printf("uid = %u\n", sfsi->i_uid);
			printf("size = %u\n", sfsi->i_size);
			printf("atime = %s",
			       ctime((time_t *)&(sfsi->i_atime)));
			printf("ctime = %s",
			       ctime((time_t *)&(sfsi->i_ctime)));
			printf("mtime = %s",
			       ctime((time_t *)&(sfsi->i_mtime)));
			printf("dtime = %s",
			       ctime((time_t *)&(sfsi->i_dtime)));
			printf("gid = %u\n", sfsi->i_gid);
			printf("links = %u\n", sfsi->i_links_count);
			printf("blocks = %u\n", sfsi->i_blocks);
			printf("flags = 0x%08X\n", sfsi->i_flags);
			printf("version = %u\n", sfsi->i_version);
			printf("file acl = %u\n", sfsi->i_file_acl);
			printf("dir acl = %u\n", sfsi->i_dir_acl);
			printf("fragaddr = %u\n", sfsi->i_faddr);
			printf("fragnum = %u\n", sfsi->osd2.linux2.l_i_frag);
			printf("fragsize = %u\n", sfsi->osd2.linux2.l_i_fsize);
			printf("icopies = %u\n", sfsi->i_icopies);
			printf("bcopies = %u\n", sfsi->i_bcopies);

			printf("inodes =");
			for(j=0; j<STEGFS_MAX_INO_COPIES; j++) {
				printf(" %u", sfsi->i_inode[j]);
			}
			printf("\n");

			printf("blocks:\n");
			for(j=0; j<STEGFS_MAX_BLOCK_COPIES; j++) {
				printf("%lu =", j);
				for(k=0; k<EXT2_N_BLOCKS; k++) {
					printf(" %u", sfsi->i_block[j*EXT2_N_BLOCKS+k]);
				}
				printf("\n");
			}
			break;
		case 'd':
			for(j=0; j<1024;) {

				dent = (struct ext2_dir_entry_2 *)(data+j);

				printf("ino: %u   reclen: %u   namelen: %u   filetype: %u\n",
				       dent->inode, dent->rec_len,
				       dent->name_len, dent->file_type);
				printf("name: %s\n",dent->name);
				j+=dent->rec_len;
			}

			break;
		case 'n':
			data32 = (unsigned int *)data;
			for(j=0; j<128; j++) {
				printf("%u  ", data32[j]);
				if(!((j+1)%8))
					printf("\n");
			}
			break;
		default:
			printf("Unknown type\n");
			exit(1);
		}
	}

	free(key);
	close_fs(fssys);
	return 0;
}
