/* $Id: stegfs.h,v 1.8 1999/09/15 14:14:51 adm36 Exp $ */
#include <stdio.h>
#include <linux/fs.h>
#include <linux/stegfs_fs.h>

/*
struct stegfs_cipher {
	char *id;
	char * (*set_key) (const char *, const unsigned int);
	void (*encrypt) (const char *, const char *, char *);
	void (*decrypt) (const char *l_key, const char *, char *out_blk);
};
*/

#define RAND_DEV	"/dev/urandom"

struct inoblocks {

	unsigned int inode;
        unsigned int block[STEGFS_MAX_INO_COPIES];
        struct inoblocks * next;

};

struct stegfs_fs {

	FILE *fsfile;
	FILE *btabfile;

	struct ext2_super_block sb;

	unsigned int *bbarray;
	unsigned int groups;

	int slevel;
	char *slkeys[STEGFS_MAX_LEVELS-1];

	struct stegfs_cipher *cipher;
};

int open_fs(struct stegfs_fs *fs, char *fsname, char *btabname, char *cipher,
	    int newfs);
int close_fs(struct stegfs_fs *fs);
void get_skeys(struct stegfs_fs *fs, int level, char *pass);
int get_stegfs_inodes(struct stegfs_fs *fs, struct inoblocks **inolist);
int get_bbpos(struct stegfs_fs *fs);
void randomize_empties(struct stegfs_fs *fs);
u_int8_t isblockused(struct stegfs_fs *fs, u_int32_t blocknum);
u_int8_t stegfs_isblockused(struct stegfs_fs *fs, u_int32_t blocknum);
u_int32_t get_new_block(struct stegfs_fs *fs);
int get_new_inode_blocks(struct stegfs_fs *fs, int slevel, int ino,
			 int numcopies, unsigned int *blocks);
void put_btab(struct stegfs_fs *fs, u_int32_t bnum,
	      struct stegfs_btable *btab);
void get_btab(struct stegfs_fs *fs, u_int32_t bnum,
	      struct stegfs_btable *btab);
unsigned int stegfs_chksum(unsigned char * data, int size);
char *make_key(struct stegfs_fs *fs, int level, unsigned int blocknum);

void encrypt_cbc(struct stegfs_fs *fs, int level, unsigned int bnum,
		 char *data, int size, unsigned short iv);
void encrypt_cbc2(struct stegfs_fs *fs, int level, unsigned int bnum,
		  char *data, char *data2, int size, unsigned short iv);
void decrypt_cbc(struct stegfs_fs *fs, int level, unsigned int bnum,
		 char *data, int size, unsigned short iv);
void decrypt_cbc2(struct stegfs_fs *fs, int level, unsigned int bnum,
		  char *data, char *data2, int size, unsigned short iv);

void encrypt_skey(struct stegfs_fs *, char *passwd, char *skey, char *skeyout);
void decrypt_skey(struct stegfs_fs *, char *passwd, char *skey, char *skeyout);

void encrypt_btab(struct stegfs_fs *fs, int slevel, unsigned int bnum,
		  struct stegfs_btable *btab);
void encrypt_btab2(struct stegfs_fs *fs, int slevel, unsigned int bnum,
		   struct stegfs_btable *btab, struct stegfs_btable *btab2);
void decrypt_btab(struct stegfs_fs *fs, int slevel, unsigned int bnum,
		  struct stegfs_btable *btab);
void decrypt_btab2(struct stegfs_fs *fs, int slevel, unsigned int bnum,
		   struct stegfs_btable *btab, struct stegfs_btable *btab2);
