/* StegFS - The Steganographic File System */
/* Copyright (c)1999 Andrew McDonald <andrew@mcdonald.org.uk> */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/stegfs_fs.h>

int main(int argc, char *argv[]) {

  int c;
  char ic = -1;
  char bc = -1;
  int error = 0;
  int fd, r;

  while (1) {

    c = getopt(argc, argv, "i:b:");

    if (c == -1)
      break;

    switch (c)
      {
      case 'i':
	ic = atoi(optarg);
	break;
      case 'b':
	bc = atoi(optarg);
	break;

      default:
	printf("Unknown option.\n");
	error = 1;
      }
  }

  /*  printf("%d %d %d\n", ic, bc, error); */

  if(error) {
    printf("tunestegfs failed\n");
    exit(1);
  }

  if(optind != argc-1) {
    printf("No file name.\n");
    exit(1);
  }


  fd = open (argv[optind], O_RDONLY|O_NONBLOCK);
  if (fd == -1)
    return -1;

  if(ic == -1 && bc == -1) {
    printf("File: %s\n", argv[optind]);
    r = ioctl (fd, STEGFS_IOC_GETICOPIES, &ic);
    if(r != 0) {
      printf("ERROR\n");
      exit(1);
    }
    printf("Inode copies: %d\n", ic);
    r = ioctl (fd, STEGFS_IOC_GETBCOPIES, &bc);
    if(r != 0) {
      printf("ERROR\n");
      exit(1);
    }
    printf("Block copies: %d\n", bc);
    close(fd);
    exit(0);
  }

  if ( (ic == -1 && (bc>0 && bc<=14)) ||
       (bc == -1 && (ic>0 && bc<=28)) ||
       ((bc>0 && bc<=14) && (ic>0 && bc<=28)) ) {

    if (ic != -1) {
      r = ioctl (fd, STEGFS_IOC_SETICOPIES, &ic);
      if(r != 0) {
	printf("ERROR\n");
	exit(1);
      }
    }

    if (bc != -1) {
      r = ioctl (fd, STEGFS_IOC_SETBCOPIES, &bc);
      if(r != 0) {
	printf("ERROR\n");
	exit(1);
      }
    }
  }

  close(fd);
  exit(0);
}
