/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /usr/src/tcfs-utils_0.1/bin/RCS/tcfs_flags.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 2000/01/14 13:44:04 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/wait.h>
#include <sys/stat.h> 
#include <tcfs.h>
#include <kdes.h>

tcfs_flags tcfs_getflags(int fd)
{
	tcfs_flags r;
	struct stat s;

	if(fstat(fd,&s)<0)
		{
		 r.flag=TCFS_EFLGS;
		}
	else
		 r.flag=s.st_flags;
	return r;
}
		 
	
tcfs_flags tcfs_setflags(int fd, tcfs_flags x)
{
	tcfs_flags r,n;
	r=tcfs_getflags(fd);
	
	if (r.flag==TCFS_EFLGS) 
		{
		 r.flag=TCFS_EFLGS;
		 return r;
		}

	n=x;
	FI_SET_SP(&n,FI_SPURE(&r));

	if(fchflags(fd,n.flag))
		 r.flag=TCFS_EFLGS;

	return r;
}
