/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /usr/src/tcfs-utils_0.1/bin/RCS/tcfsrun.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 2000/01/14 13:44:04 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */


#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/wait.h>
#include <kdes.h>
#include <tcfs.h>

char *usage= "usage: tcfstat [-p mount-point | fs-label]";

void main(int argc, char *argv[], char *envp[])
{
	struct tcfs_status st;	
	int e,es,ok=0;
	char filesystem[255];
	
	if (argc==3 && !strcmp("-p",argv[1]))
	{
		strcpy(filesystem,argv[2]);
		ok=1;
	}

	if (argc==2)
	{
                 if(!(es=tcfs_getfspath(argv[1],filesystem)))
                 {
	                 fprintf(stderr,"filesystem label not found!\n");
       		         exit(1);
                 }
		 ok=1;
	}

	if(ok==0 || argc<2 || argc>3)
        {       
                fprintf(stderr,"%s\n",usage);
                exit(1);
        }

	
	e=tcfs_getstatus(filesystem,&st);
	if(e==-1)
		{
			fprintf(stderr,"filesystem %s not mounted\n",filesystem);
			exit(1);
		}
	
	printf("Status: %d; user keys: %d, group keys: %d\n",st.status, st.n_ukey, st.n_gkey);
	printf("TCFS version: %d, Cipher: %s, keysize: %d, cipher version: %d\n",st.tcfs_version, st.cipher_desc, st.cipher_keysize, st.cipher_version);
			
	
}

