/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /usr/src/tcfs-utils_0.1/lib/RCS/tcfs_keymaint.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 2000/01/14 13:44:51 $
 *
 */

/* RCS_HEADER_ENDS_HERE */



#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <kdes.h>
#include <tcfs.h>
#include <tcfsdefines.h>
#include<sys/ucred.h>


int tcfs_getstatus(char *filesystem, struct tcfs_status *st)
{
	int i;
	struct tcfs_args x;

	if(!tcfs_verify_fs(filesystem))
		return -1;	
	x.cmd=TCFS_GET_STATUS;
	i=tcfs_callfunction(filesystem,&x);
	*st=x.st;
	return i;
}
