/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /usr/src/tcfs-utils_0.1/include/RCS/tcfs.h,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 2000/01/14 13:45:28 $
 *
 */

/* RCS_HEADER_ENDS_HERE */



#ifndef _DES_H_
#include <kdes.h>
#endif

#define MaxCipherNameLen 8
struct tcfs_status {
			int	status;
			int 	n_ukey;
			int	n_gkey;
			int	tcfs_version;
			char	cipher_desc[MaxCipherNameLen];
			int	cipher_keysize;
			int	cipher_version;
		   };

struct tcfs_args {
	char		*target;	/* Target of loopback   */
	char 		*des_key;	/* chiave 		*/
	int		cipher_num;
	int		cmd;		/* direttiva		*/
	uid_t		user;		/* utente		*/
	pid_t		proc;		/* processo		*/
	gid_t		group;		/* gruppo		*/
	int		treshold;	/* soglia grpkey	*/
	struct tcfs_status	st;	
};

/*	tcfs commands		*/	

#define TCFS_PUT_UIDKEY		1
#define TCFS_RM_UIDKEY		2
#define TCFS_PUT_PIDKEY		3
#define	TCFS_RM_PIDKEY		4
#define	TCFS_PUT_GIDKEY		5
#define TCFS_RM_GIDKEY		6
#define	TCFS_GET_STATUS		7

/*	tcfs errors		*/
#define TCFS_OK			0
#define UNKNOWN_COMMAND		1
#define	BAD_CIPHER_NUMBER	2
#define PIDKEY_ERROR		3

/*	Gestione informazioni sui files cifrati
*/

typedef struct 
	{
	 unsigned long flag;
	} tcfs_flags;

#define         MBFLAG  0x00000010
#define         SPFLAG  0x000000e0
#define         GSFLAG  0x00000100

#define FI_CFLAG(x)     (((x)->flag&MBFLAG)>>4)
#define FI_SPURE(x)     (((x)->flag&SPFLAG)>>5)
#define FI_GSHAR(x)     (((x)->flag&GSFLAG)>>8)

#define FI_SET_CF(x,y)  ((x)->flag=\
                         ((x)->flag & (~MBFLAG))|((y<<4)&MBFLAG))

#define FI_SET_SP(x,y)  ((x)->flag=\
                         ((x)->flag & (~SPFLAG))|((y<<5)&SPFLAG))

#define FI_SET_GS(x,y)  ((x)->flag=\
                         ((x)->flag & (~GSFLAG))|((y<<8)&GSFLAG))


#define TCFS_EFLGS	-1

