#include <sys/param.h>
#include <sys/systm.h>
#include <sys/malloc.h>
#include "tcfs_cipher.h"
#include "ciphers/rc5.h"


void *RC5_init_key (char *key)
{
	rc5_key_schedule *ks=NULL;

	ks=(rc5_key_schedule *)malloc (sizeof (rc5_key_schedule),M_FREE,M_NOWAIT);
	if (!ks) {
		return NULL;
	}

	rc5_setup (key, (WORD *)*ks);

	return (void *)ks;
}
void RC5_cleanup_key(void *k)
{
	free((rc5_key_schedule*)k,M_FREE);
}

void RC5_encrypt(char *block, int nb, void *key)
{
	unsigned long *xi;
	int i;
	char *tmp;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	xi=(long *)block;
	tmp=block;
	rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
	memcpy (tmp, ct, 8L);
	tmp+=8;

	for (i=1;i<nb/8;i++) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
		memcpy (tmp, ct, 8L);
		tmp+=8;
		xi+=2;
	}
}

void RC5_decrypt(char *block, int nb, void *key)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	xi=(long *)block;
	tmp=block;
	xo[0]=*xi; xo[1]=*(xi+1);

	if ((xo[0]|xo[1])!=0L) {
		rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
		memcpy(tmp,ct,8L);
	}
	tmp+=8;
	xi=(long *)tmp;

	for (i=1;i<nb/8;i++) {
		xa[0]=*xi; xa[1]=*(xi+1);
		if ((xa[0]|xa[1])!=0L) {
			rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
			memcpy(tmp,ct,8L);
		}
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}
}
