/*	$OpenBSD: tcfs_attr.c,v 1.3 2000/06/17 20:25:54 provos Exp $	*/
/*
 * Copyright 2000 The TCFS Project at http://tcfs.dia.unisa.it/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/mount.h>
#include <sys/namei.h>
#include <sys/malloc.h>
#include <sys/buf.h>

#include <miscfs/tcfs/tcfs.h>
#include <miscfs/tcfs/tcfs_rw.h>


extern int groupmember __P((gid_t,struct ucred *));

int
tcfs_getattr(v)
        void *v;
{
        struct vop_getattr_args *ap = v;
        int error;
	tcfs_fileinfo i;
        if ((error = tcfs_bypass(ap)) != 0)
                return (error);
        /* Requires that arguments be restored. */

        ap->a_vap->va_fsid = ap->a_vp->v_mount->mnt_stat.f_fsid.val[0];
	i.flag=ap->a_vap->va_flags; 
	ap->a_vap->va_size-=FI_SPURE(&i);

        return (0);
}


int           
tcfs_setattr(v)
	void *v;
{
	struct vop_setattr_args *a = v;
	struct vattr *ap;
	u_quad_t size = 0;
	tcfs_fileinfo current_flags, new_flags;
	int error, sp = 0;
	int set_other=0,set_x=0,set_g=0;
	int have_x=0,have_g=0;
	int have_ukey=0,have_gkey=0;
			
	current_flags = tcfs_xgetflags(a->a_vp,a->a_p,a->a_cred);

	if(current_flags.uid!=a->a_cred->cr_uid)
		{
#ifdef TCFS_DEBUG
			printf("setattr: not owner!\n");
#endif
			return EACCES;
		}

	if(!groupmember(current_flags.gid,a->a_cred))
	{
#ifdef TCFS_DEBUG
			printf("setattr: not member!\n");
#endif
			return EACCES;
	}

	ap = a->a_vap;

	new_flags.flag = ap->va_flags;
	new_flags.uid=a->a_cred->cr_uid;
	new_flags.gid=current_flags.gid;

	set_other=(new_flags.flag==VNOVAL);


	if(!set_other)
	{
		
		set_g=FI_GSHAR(&new_flags);
		set_x=FI_CFLAG(&new_flags);
		have_g=FI_GSHAR(&current_flags);
		have_x=FI_CFLAG(&current_flags);
		new_flags.end_of_file = current_flags.end_of_file;

/*
		check bad requests
*/

		if(set_x&&set_g)
		{
#ifdef TCFS_DEBUG
			printf("setattr: set_x and set_g\n");
#endif
			return EINVAL;
		}

/*
		fail if x->g or g->x 
*/

		if(set_x&&have_g)
		{
#ifdef TCFS_DEBUG
			printf("setattr: set_x and have_g\n");
#endif
			return EINVAL;
		}
		if(set_g&&have_x)
		{
#ifdef TCFS_DEBUG
			printf("setattr: set_g and have_x\n");
#endif
			return EINVAL;
		}

/* 		
		is the proper key present?
*/

		have_ukey=tcfs_checkukey(a->a_cred->cr_uid,a->a_p,a->a_vp)||
			tcfs_checkpkey(a->a_cred->cr_uid,a->a_p,a->a_vp);
		have_gkey=tcfs_checkgkey(new_flags.gid,a->a_p,a->a_vp);
		

		if(set_x&&(!have_ukey))
		{
#ifdef TCFS_DEBUG	
			printf("setattr: set_x and !have_ukey\n");
#endif
			return EACCES;
		}

		if(set_g&&(!have_gkey))
		{
#ifdef TCFS_DEBUG
			printf("setattr: set_g and !have_gkey\n");
#endif
			return EACCES;
		}

		if((!(set_x || set_g)) && have_x && (!have_ukey))
		{	
#ifdef TCFS_DEBUG
			printf("setattr: !set_x without have_ukey\n");
#endif
			return EINVAL;
		}

		if((!(set_x || set_g)) && have_g && (!have_gkey))
		{	
#ifdef TCFS_DEBUG
			printf("setattr: !set_g without have_gkey\n");
#endif
			return EINVAL;
		}
		

		if(set_x && !have_x)
		{
#ifdef TCFS_DEBUG
			printf("setattr: set_x and !have_x encrypt.\n");
#endif
			sp = tcfs_ed(a->a_vp, a->a_p, a->a_cred, &new_flags,
								TCFS_UEN);
			FI_SET_SP(&new_flags, sp);
		}

		if(!set_x && have_x)
		{
#ifdef TCFS_DEBUG
			printf("setattr: !set_x and have_x decrypt.\n");
#endif
			sp = tcfs_ed(a->a_vp, a->a_p, a->a_cred, &new_flags,
								TCFS_UDE);
			FI_SET_SP(&new_flags, 0);
		}

		if(set_g && !have_g)
		{
#ifdef TCFS_DEBUG
                        printf("setattr: set_g and !have_g encrypt.\n");
#endif                  

			sp = tcfs_ed(a->a_vp, a->a_p, a->a_cred, &new_flags,
								TCFS_GEN);
			FI_SET_SP(&new_flags, sp);
		}

		if(!set_g && have_g)
		{
#ifdef TCFS_DEBUG
                        printf("setattr: !set_g and have_g decrypt.\n");
#endif

			sp = tcfs_ed(a->a_vp, a->a_p, a->a_cred, &new_flags,
								TCFS_GDE);
			FI_SET_SP(&new_flags,0);
		}

		ap->va_flags = new_flags.flag;

		if (a->a_vp->v_type == VREG) 
		{
			ap->va_size = FI_ENDOF(&new_flags) + sp;
			error = tcfs_xsetflags(a->a_vp, a->a_p, a->a_cred,&new_flags);
		}
		return tcfs_bypass((void *)v);
	}/* !set_other*/

	if ((ap->va_size) != VNOVAL) 
	{
		if (ap->va_size == 0)
			size = 0;
		else
			size = (u_quad_t)(D_PFOFF(ap->va_size) + 1);


		FI_SET_SP(&current_flags,(size-ap->va_size));
		ap->va_size = size;
		error = tcfs_xsetflags(a->a_vp, a->a_p,a->a_cred, &current_flags);
	}

	return tcfs_bypass((void *)v);
}

