/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/cipher/tcfs_3des_cipher.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:29 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */


#include "des.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define PAD	"\x7F\xFF\xFF\xFF\xFF\xFF\xFF\xFF"
#define PAD0	'\x7F'

void *tcfs_init_key (char *key)
{
	des_key_schedule *ks;

#ifdef TCFS_DEBUG
	fprintf(stderr,"tcfs_init_key: Initializing 3DES key\n");
	fprintf(stderr,"\ntcfs_init_key: Execute init_key");
#endif

	ks=(des_key_schedule *)malloc (sizeof (des_key_schedule));
	if (!ks) {
		fprintf (stderr,"\ntcfs_init_key: unable to get memory\n");
		return NULL;
	}

	des_set_key ((des_cblock *)key, ks[0]);

#ifdef TCFS_DEBUG
        {
                int i;
                char *pnt;

                fprintf(stderr,"\ntcfs_init_key: output key: ");

                pnt=(char *)&ks[0];   
                for(i=0;i<16;i++,pnt++){
                        fprintf(stderr,"%X:",(unsigned int)*pnt);       
                }
                fprintf(stderr,"\n"); 
        }
#endif
	
	return (void *)ks;
}

char* tcfs_encrypt(char *block, int nb, void *key,int* len)	

{
	unsigned long * xi;
	int i;
	char *tmp,*crypted;
	des_key_schedule *ks=(des_key_schedule *)key;


	*len=((nb+strlen(PAD))/8)*8;
	crypted=(char*) malloc(*len);
	memcpy(crypted,block,nb);
	tmp=crypted+nb;
	memcpy(tmp,PAD,strlen(PAD));


#ifdef TCFS_DEBUG
	{       
                int i;  
                char *pnt;
    
		fprintf(stderr,"\ntcfs_encrypt: in tcfs_encrypt\n");
                fprintf(stderr,"\ntcfs_encrypt: block being crypted: ");
    
                pnt=crypted;
                for(i=0;i<*len;i++,pnt++){
                        fprintf(stderr,"%x:",(unsigned int)*pnt);
                }       
    		fprintf(stderr,"\n");
	} 
#endif

	xi=(unsigned long *)crypted;
	tmp=crypted;
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,(des_key_schedule*) ks,DES_ENCRYPT);
	tmp+=8;
	for (i=8;i<*len;i+=8) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,(des_key_schedule*) ks,DES_ENCRYPT);
		tmp+=8;
		xi+=2;
	}

#ifdef TCFS_DEBUG
	fprintf (stderr,"\ntcfs_encrypt: exiting tcfs_encrypt\n");
#endif

	return(crypted);
	
}

char* tcfs_decrypt(char *block, int nb, void *key,int *len)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp,*decrypted;
	des_key_schedule *ks=(des_key_schedule *)key;

	decrypted=(char*) malloc(nb);
	memcpy(decrypted,block,nb);
	
#ifdef TCFS_DEBUG
        {
                int i;
                char *pnt=block;

                fprintf(stderr,"\ntcfs_decrypt: block being decrypted ");

                for(i=0;i<nb;i++,pnt++){
                        fprintf(stderr,"%X:",(unsigned int)*pnt);
                }
                fprintf(stderr,"\n");
        }
#endif

	xi=(unsigned long *)decrypted;
	tmp=decrypted;
	xo[0]=*xi; xo[1]=*(xi+1);
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,(des_key_schedule*) ks,DES_DECRYPT);
	tmp+=8;
	xi=(unsigned long *)tmp;
	for (i=8;i<nb;i+=8) {
		xa[0]=*xi; xa[1]=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,(des_key_schedule*) ks,DES_DECRYPT);
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}
		
	{
		char* last=memchr(decrypted,PAD0,nb);
		int dim=nb;

		while (last!=NULL) {
			tmp=last;
			dim=nb-((tmp+1)-decrypted);
			last=memchr(tmp+1,PAD0,dim);
		}
	}
	
	*tmp='\0';
	*len=tmp-decrypted;

	return(decrypted);
}

void tcfs_delete_key(void *key) {
	
	free((des_key_schedule*) key);

}
