/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/cipher/tcfs_rc5_cipher.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:29 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "rc5.h"

void *tcfs_init_key(char *key)
{
	rc5_key_schedule *ks=NULL;

	ks=(rc5_key_schedule *)malloc (sizeof (rc5_key_schedule));
	if (!ks) {
		fprintf (stderr,"\ntcfs_init_key: unable to get memory\n");
		return NULL;
	}

#ifdef TCFS_DEBUG
	fprintf(stderr,"tcfs_init_key: Initializing RC5 key\n");
#endif

	rc5_setup ((unsigned char*)key, (WORD *)*ks);

#ifdef TCFS_DEBUG
        {
                int i;
                char *pnt;

                fprintf(stderr,"\ntcfs_init_key: output key: ");       

                pnt=(char *)&ks[0];   
                for(i=0;i<16;i++,pnt++){
                        fprintf(stderr,"%X:",(unsigned int)*pnt);      
                }
                fprintf(stderr,"\n"); 
        }
#endif
	
	return (void *)ks;
}

char* tcfs_encrypt(char *block, int nb, void *key, int* len)
{
	unsigned long *xi;
	int i;
	char *tmp, *crypted;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	*len=nb;
	crypted=(char*) malloc(*len);
        memcpy(crypted,block,nb);

#ifdef TCFS_DEBUG
        {       
                int i;  
                char *pnt;
    
                fprintf(stderr,"\ntcfs_encrypt: in tcfs_encrypt\n");
                fprintf(stderr,"\ntcfs_encrypt: block being crypted: ");
    
                pnt=crypted;
                for(i=0;i<*len;i++,pnt++){
                        fprintf(stderr,"%x:",(unsigned int)*pnt);
                }       
                fprintf(stderr,"\n");
        } 
#endif
	
	xi=(unsigned long *) crypted;
	tmp=crypted;
	rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
	memcpy (tmp, ct, 8L);
	tmp+=8;

	for (i=1;i<nb/8;i++) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
		memcpy (tmp, ct, 8L);
		tmp+=8;
		xi+=2;
	}

	return(crypted);
}

char* tcfs_decrypt(char *block, int nb, void *key, int* len)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp, *decrypted;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	*len=nb;
	decrypted=(char*) malloc(nb);
        memcpy(decrypted,block,nb);
	
#ifdef TCFS_DEBUG
        {
                int i;
                char *pnt=block;

                fprintf(stderr,"\ntcfs_decrypt: block being decrypted ");

                for(i=0;i<nb;i++,pnt++){
                        fprintf(stderr,"%X:",(unsigned int)*pnt);
                }
                fprintf(stderr,"\n");
        }
#endif
	
	xi=(unsigned long *)decrypted;
	tmp=decrypted;
	xo[0]=*xi; xo[1]=*(xi+1);

	if ((xo[0]|xo[1])!=0L) {
		rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
		memcpy(tmp,ct,8L);
	}
	tmp+=8;
	xi=(unsigned long *)tmp;

	for (i=1;i<nb/8;i++) {
		xa[0]=*xi; xa[1]=*(xi+1);
		if ((xa[0]|xa[1])!=0L) {
			rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
			memcpy(tmp,ct,8L);
		}
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}

	return(decrypted);
}

void tcfs_delete_key(void *key) {
        
        free((rc5_key_schedule*) key);

}
