
/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/include/tcfs_flags.h,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:30 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

/* START OF FLAGS MANAGEMENT SECTION */

typedef struct
        {
         unsigned long flag;    
        } tcfs_flags;

#define         MBFLAG  0x00000010
#define         SPFLAG  0x000000e0
#define         GSFLAG  0x00000100

#define RESET_FLAG(x) 	((x)->flag=0)

#define FI_CFLAG(x)     (((x)->flag&MBFLAG)>>4)
#define FI_SPURE(x)     (((x)->flag&SPFLAG)>>5)
#define FI_GSHAR(x)     (((x)->flag&GSFLAG)>>8)

#define FI_SET_CF(x)  ((x)->flag |= MBFLAG)

#define FI_SET_SP(x,y)  ((x)->flag=\
                         ((x)->flag & (~SPFLAG))|((y<<5)&SPFLAG))      

#define FI_SET_GS(x)  ((x)->flag |= GSFLAG) 

#define FI_UNSET_CF(x) ((x)->flag &= ~MBFLAG)
#define FI_UNSET_GS(x) ((x)->flag &= ~GSFLAG)

#define TCFS_EFLGS      (unsigned long)-1


/* Prototypes for TCFS flags management */

tcfs_flags tcfs_getflags(int);
tcfs_flags tcfs_setflags(int, tcfs_flags);

/* END OF FLAGS MANAGEMENT SECTION */


