
/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/include/tcfs_key.h,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:30 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

/* START OF KEY MANAGEMENT SECTION */


/* This is used to refer to the cipher dynamic library's function  */
#define TCFS_INIT_KEY	"_tcfs_init_key"
#define TCFS_ENCRYPT	"_tcfs_encrypt"
#define TCFS_DECRYPT	"_tcfs_decrypt"
#define TCFS_DELETE_KEY	"_tcfs_delete_key"  

/* This is the name of the file that defines the cipher to use */
#define TCFS_CIPHER_CONF "/usr/tcfs/etc/cipher.conf"

/* This are the keyword of the dynamic library's configuration file */
#define TCFS_CIPHER_KEYWORD	"cipher"

#define TCFS_CIPHER_COMMENT	'#'
#define DELIM 			"\t \n"


#define TCFS_USER_KEY	0 	/* It's used in the encrypt/decrypt function */
#define TCFS_GROUP_KEY	1

#define TCFS_FSTYPE	"tcfs"

/* This is used to interface with the TCFS core */

#define MaxCipherNameLen 8

	/* This was defined typedef because it is directly used by utility */
typedef struct tcfs_status {
                        int     status;
                        int     n_ukey;
                        int     n_gkey;
                        int     tcfs_version;
                        char    cipher_desc[MaxCipherNameLen];
                        int     cipher_keysize;
                        int     cipher_version;
} tcfs_status;

struct tcfs_args {
        char            *target;        /* Target of loopback   */      
        u_char          tcfs_key[KEYSIZE];   /* chiave               */      
        int             cipher_num;   
        int             cmd;            /* direttiva            */      
        uid_t           user;           /* utente               */      
        pid_t           proc;           /* processo             */      
        gid_t           group;          /* gruppo               */      
        int             treshold;       /* soglia grpkey        */      
        struct tcfs_status      st;   
};

#define TCFS_PUT_UIDKEY         1
#define TCFS_RM_UIDKEY          2
#define TCFS_PUT_PIDKEY         3
#define TCFS_RM_PIDKEY          4
#define TCFS_PUT_GIDKEY         5
#define TCFS_RM_GIDKEY          6
#define TCFS_GET_STATUS         7


/* Prototypes for TCFS key management */
 
char* gentcfskey(void);
// static int _tcfs_get_library_name(void);
// static int _tcfs_load_cipher_function(void);
// static void _tcfs_unload_cipher_function(void);
char* tcfs_encrypt_key(char*, char*, int);
char* tcfs_decrypt_key(char*, char*, int);
// static int _tcfs_mount_interface(char*, struct tcfsargs *);
int tcfs_user_enable(const char*, uid_t, char*);
int tcfs_user_disable(const char*, uid_t);
int tcfs_process_enable(const char*, uid_t, pid_t, char*);
int tcfs_process_disable(const char*, uid_t, pid_t);
int tcfs_group_enable(const char*, uid_t, gid_t, int, char*);
int tcfs_group_disable(const char*, uid_t, gid_t);
int tcfs_getstatus(const char*, tcfs_status*);

/* END OF KEY MANAGEMENT SECTION */


