/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/lib/tcfs_base64.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:31 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "tcfs_base64.h"
#include "tcfs_errno.h"

static const char *base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/* It encodes the string src of length srclen. It creates memory for the string returned. On success return the pointer to the encoded string */

char* tcfs_base64_encode(char *src,int srclen) {

        char *ptr, *result, byte0, byte1, byte2, byte3;
	unsigned int extra_byte,iterations,index=0;
	
	if (srclen>MAX_BASE64) {
		tcfs_errno=ER_BASE64_MAX;
		return(NULL);
	}

	iterations = srclen / 3;	
	extra_byte = srclen % 3;
	
	ptr=src;

#ifdef TCFS_DEBUG
	{ int i;
	fprintf(stderr,"tcfs_base64_encode: malloc %d bytes\n",4*iterations+((extra_byte>0)?4:0)+1);
	fprintf(stderr,"tcfs_base64_encode: src \n");
	for (i=0;i<srclen;i++) 
		fprintf(stderr,"%X ",src[i]);
	fprintf(stderr,"\n");
	}
#endif

	result=(char*)malloc(4*iterations+((extra_byte>0)?4:0)+1);

	if (result==NULL) {
		tcfs_errno=ER_MEM;
		return (char*)0;
	}

	tcfs_errno=OK;

	strcpy(result,"\0");

	while (iterations-- > 0) {
	
		/* The right shift is followed by an & operation. This is 
		because the right shift could add one on the right. It 
		depends from implementations */
	
		byte0 = (ptr[0] >> 2) & 0x3F; 
		byte1 = (((ptr[0] & 0x03) << 4) | ((ptr[1] >> 4) & 0x0F)); 
		byte2 = (((ptr[1] & 0x0F) << 2) | ((ptr[2] >> 6) & 0x03)); 
		byte3 = ptr[2] & 0x3F; 
		
		result[index]=*(base64+byte0);
		result[index+1]=*(base64+byte1);
		result[index+2]=*(base64+byte2);
		result[index+3]=*(base64+byte3);
		
		index+=4;
		ptr+=3;
	}
	
	if (extra_byte==0) {
		result[index]='\0';
		return(result);
	}

	if (extra_byte==1) {
		
		byte0 = (ptr[0] >> 2) & 0x3F;
		byte1 = (ptr[0] & 0x03) << 4;
		
		result[index+2]=PAD;
	}
		
	else { 	/* extra_byte=2 */ 
		
		byte0 = (ptr[0] >> 2) & 0x3F;
		byte1 = (((ptr[0] & 0x03) << 4) | ((ptr[1] >> 4) & 0x0F));
		byte2 = (ptr[1] & 0x0F) << 2; 
	
		result[index+2]=*(base64+byte2);
	}
	
	result[index]=*(base64+byte0);
	result[index+1]=*(base64+byte1);
	result[index+3]=PAD;
	result[index+4]='\0';

#ifdef TCFS_DEBUG
        {
        unsigned int i=0;
        fprintf(stderr,"tcfs_base64_encode: string encoded = ");
        for (;i<=strlen(result);i++)
                fprintf(stderr,"%X ",(unsigned char) result[i]);
        fprintf(stderr,"\n");
        }
#endif

	return(result);
}


/* It decodes a string. It creates memory for the string returned. On success return the pointer to the decoded string and the length. */

char* tcfs_base64_decode(char *src,int *len) {

	unsigned int index=0,last_char=0,iterations=0;
	char *ptr=src, *result, *base64_pos, base64_code;
	int ch=*ptr, srclen=strlen(src);

#ifdef TCFS_DEBUG
	fprintf(stderr,"tcfs_base64_decode: strlen(%s):%d\n",src,srclen);
	fprintf(stderr,"tcfs_base64_decode: malloc %d bytes\n",((srclen*3)/4)+1);
#endif	

	if ((srclen%4)!=0) {
		tcfs_errno=ER_BASE64_MUL;
		return (char*)0;
	}
	*len=((srclen*3)/4)+1;
	result=(char*) malloc(*len); /* +1 is for '\0' */

	if (result==NULL) {
		tcfs_errno=ER_MEM;
		return (char*)0;
	}

	while ((ch!='\0') && (ch!=PAD)) {

		base64_pos=strchr(base64,ch);
		if (base64_pos==NULL) {

#ifdef TCFS_DEBUG
	fprintf(stderr,"tcfs_base64_decode: illegal character: %c\n",ch);
#endif

			tcfs_errno=ER_BASE64_ILLCHR;
			free(result);
			return (char*)0;
		}
		
		base64_code=base64_pos-base64;
	
		switch(iterations%4) {

			case 0:
				result[index]=base64_code << 2;
				last_char=index-1;
				break;

			case 1:
				/* Differently from the tcfs_base64_encode, there is no need to clear bits after a right shift because a base64_code is always unsigned */
				result[index]|=base64_code >> 4;
				result[index+1]=base64_code << 4;
				last_char=index;
				break;

			case 2:
				result[index+1]|=base64_code >> 2;
				result[index+2]=base64_code << 6;
				last_char=index+1;
				break;

			case 3:
				result[index+2]|=base64_code;
				last_char=index+2;
				index+=3;
				break;
		}

		iterations++;
		ch=*(++ptr);

	}

	result[last_char+1]='\0';
	*len=last_char+1;
	tcfs_errno=OK;
	return(result);	
		
}
