/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/lib/tcfs_flags.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1.1.1 $
 *	  $Author: fergia $
 *	    $Date: 2000/06/07 12:21:31 $
 *
 */


/* RCS_HEADER_ENDS_HERE */



#include <sys/types.h>
#include <sys/stat.h> 
#include <unistd.h>
#include "tcfs_flags.h"
#include "tcfs_global.h"
#include "tcfs_errno.h"

tcfs_flags tcfs_getflags(int fd) {

	tcfs_flags r;
	struct stat s;

	tcfs_errno=OK;

	if(fstat(fd,&s)<0) {
		
		r.flag=TCFS_EFLGS;
		tcfs_errno=ER_GET_FLAGS;

	}	
	else
		r.flag=s.st_flags;

	return r;
}
		 
	
tcfs_flags tcfs_setflags(int fd, tcfs_flags x) {

	tcfs_flags r,n;
	r=tcfs_getflags(fd);

	tcfs_errno=OK;
		
	if (r.flag==TCFS_EFLGS) { 
		
		r.flag=TCFS_EFLGS;
		tcfs_errno=ER_SET_FLAGS;
		return r;
	}

	n=x;
	FI_SET_SP(&n,FI_SPURE(&r));

	if(fchflags(fd,n.flag)) {
		tcfs_errno=ER_SET_FLAGS;
		r.flag=TCFS_EFLGS;
	}

	return r;
}
